/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponseSnappedDeparturePositionsListCopier;
import software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponseSnappedDestinationPositionsListCopier;
import software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.RouteMatrixCopier;
import software.amazon.awssdk.services.location.model.RouteMatrixEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteMatrixResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, CalculateRouteMatrixResponse> {
    private static final SdkField<List<List<RouteMatrixEntry>>> ROUTE_MATRIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteMatrix").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::routeMatrix)).setter(CalculateRouteMatrixResponse.setter(Builder::routeMatrix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteMatrix").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteMatrixEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<List<Double>>> SNAPPED_DEPARTURE_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnappedDeparturePositions").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::snappedDeparturePositions)).setter(CalculateRouteMatrixResponse.setter(Builder::snappedDeparturePositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedDeparturePositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<List<Double>>> SNAPPED_DESTINATION_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnappedDestinationPositions").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::snappedDestinationPositions)).setter(CalculateRouteMatrixResponse.setter(Builder::snappedDestinationPositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedDestinationPositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<CalculateRouteMatrixSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::summary)).setter(CalculateRouteMatrixResponse.setter(Builder::summary)).constructor(CalculateRouteMatrixSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_MATRIX_FIELD, SNAPPED_DEPARTURE_POSITIONS_FIELD, SNAPPED_DESTINATION_POSITIONS_FIELD, SUMMARY_FIELD));
    private final List<List<RouteMatrixEntry>> routeMatrix;
    private final List<List<Double>> snappedDeparturePositions;
    private final List<List<Double>> snappedDestinationPositions;
    private final CalculateRouteMatrixSummary summary;

    private CalculateRouteMatrixResponse(BuilderImpl builder) {
        super(builder);
        this.routeMatrix = builder.routeMatrix;
        this.snappedDeparturePositions = builder.snappedDeparturePositions;
        this.snappedDestinationPositions = builder.snappedDestinationPositions;
        this.summary = builder.summary;
    }

    public final boolean hasRouteMatrix() {
        return this.routeMatrix != null && !(this.routeMatrix instanceof SdkAutoConstructList);
    }

    public final List<List<RouteMatrixEntry>> routeMatrix() {
        return this.routeMatrix;
    }

    public final boolean hasSnappedDeparturePositions() {
        return this.snappedDeparturePositions != null && !(this.snappedDeparturePositions instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> snappedDeparturePositions() {
        return this.snappedDeparturePositions;
    }

    public final boolean hasSnappedDestinationPositions() {
        return this.snappedDestinationPositions != null && !(this.snappedDestinationPositions instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> snappedDestinationPositions() {
        return this.snappedDestinationPositions;
    }

    public final CalculateRouteMatrixSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteMatrix() ? this.routeMatrix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnappedDeparturePositions() ? this.snappedDeparturePositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnappedDestinationPositions() ? this.snappedDestinationPositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixResponse)) {
            return false;
        }
        CalculateRouteMatrixResponse other = (CalculateRouteMatrixResponse)((Object)obj);
        return this.hasRouteMatrix() == other.hasRouteMatrix() && Objects.equals(this.routeMatrix(), other.routeMatrix()) && this.hasSnappedDeparturePositions() == other.hasSnappedDeparturePositions() && Objects.equals(this.snappedDeparturePositions(), other.snappedDeparturePositions()) && this.hasSnappedDestinationPositions() == other.hasSnappedDestinationPositions() && Objects.equals(this.snappedDestinationPositions(), other.snappedDestinationPositions()) && Objects.equals(this.summary(), other.summary());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteMatrixResponse").add("RouteMatrix", this.hasRouteMatrix() ? this.routeMatrix() : null).add("SnappedDeparturePositions", (Object)(this.snappedDeparturePositions() == null ? null : "*** Sensitive Data Redacted ***")).add("SnappedDestinationPositions", (Object)(this.snappedDestinationPositions() == null ? null : "*** Sensitive Data Redacted ***")).add("Summary", (Object)this.summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteMatrix": {
                return Optional.ofNullable(clazz.cast(this.routeMatrix()));
            }
            case "SnappedDeparturePositions": {
                return Optional.ofNullable(clazz.cast(this.snappedDeparturePositions()));
            }
            case "SnappedDestinationPositions": {
                return Optional.ofNullable(clazz.cast(this.snappedDestinationPositions()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixResponse, T> g) {
        return obj -> g.apply((CalculateRouteMatrixResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<List<RouteMatrixEntry>> routeMatrix = DefaultSdkAutoConstructList.getInstance();
        private List<List<Double>> snappedDeparturePositions = DefaultSdkAutoConstructList.getInstance();
        private List<List<Double>> snappedDestinationPositions = DefaultSdkAutoConstructList.getInstance();
        private CalculateRouteMatrixSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixResponse model) {
            super(model);
            this.routeMatrix(model.routeMatrix);
            this.snappedDeparturePositions(model.snappedDeparturePositions);
            this.snappedDestinationPositions(model.snappedDestinationPositions);
            this.summary(model.summary);
        }

        public final List<List<RouteMatrixEntry.Builder>> getRouteMatrix() {
            List<List<RouteMatrixEntry.Builder>> result = RouteMatrixCopier.copyToBuilder(this.routeMatrix);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteMatrix(Collection<? extends Collection<RouteMatrixEntry.BuilderImpl>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copyFromBuilder(routeMatrix);
        }

        @Override
        public final Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copy(routeMatrix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeMatrix(Collection<RouteMatrixEntry> ... routeMatrix) {
            this.routeMatrix((Collection<? extends Collection<RouteMatrixEntry>>)Arrays.asList(routeMatrix));
            return this;
        }

        public final Collection<? extends Collection<Double>> getSnappedDeparturePositions() {
            if (this.snappedDeparturePositions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snappedDeparturePositions;
        }

        public final void setSnappedDeparturePositions(Collection<? extends Collection<Double>> snappedDeparturePositions) {
            this.snappedDeparturePositions = CalculateRouteMatrixResponseSnappedDeparturePositionsListCopier.copy(snappedDeparturePositions);
        }

        @Override
        public final Builder snappedDeparturePositions(Collection<? extends Collection<Double>> snappedDeparturePositions) {
            this.snappedDeparturePositions = CalculateRouteMatrixResponseSnappedDeparturePositionsListCopier.copy(snappedDeparturePositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedDeparturePositions(Collection<Double> ... snappedDeparturePositions) {
            this.snappedDeparturePositions((Collection<? extends Collection<Double>>)Arrays.asList(snappedDeparturePositions));
            return this;
        }

        public final Collection<? extends Collection<Double>> getSnappedDestinationPositions() {
            if (this.snappedDestinationPositions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snappedDestinationPositions;
        }

        public final void setSnappedDestinationPositions(Collection<? extends Collection<Double>> snappedDestinationPositions) {
            this.snappedDestinationPositions = CalculateRouteMatrixResponseSnappedDestinationPositionsListCopier.copy(snappedDestinationPositions);
        }

        @Override
        public final Builder snappedDestinationPositions(Collection<? extends Collection<Double>> snappedDestinationPositions) {
            this.snappedDestinationPositions = CalculateRouteMatrixResponseSnappedDestinationPositionsListCopier.copy(snappedDestinationPositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedDestinationPositions(Collection<Double> ... snappedDestinationPositions) {
            this.snappedDestinationPositions((Collection<? extends Collection<Double>>)Arrays.asList(snappedDestinationPositions));
            return this;
        }

        public final CalculateRouteMatrixSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(CalculateRouteMatrixSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(CalculateRouteMatrixSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CalculateRouteMatrixResponse build() {
            return new CalculateRouteMatrixResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRouteMatrixResponse> {
        public Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> var1);

        public Builder routeMatrix(Collection<RouteMatrixEntry> ... var1);

        public Builder snappedDeparturePositions(Collection<? extends Collection<Double>> var1);

        public Builder snappedDeparturePositions(Collection<Double> ... var1);

        public Builder snappedDestinationPositions(Collection<? extends Collection<Double>> var1);

        public Builder snappedDestinationPositions(Collection<Double> ... var1);

        public Builder summary(CalculateRouteMatrixSummary var1);

        default public Builder summary(Consumer<CalculateRouteMatrixSummary.Builder> summary) {
            return this.summary((CalculateRouteMatrixSummary)((CalculateRouteMatrixSummary.Builder)CalculateRouteMatrixSummary.builder().applyMutation(summary)).build());
        }
    }
}

