/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to enable or modify the automatic snapshot add-on for an Amazon Lightsail instance or disk.
 * </p>
 * <p>
 * When you modify the automatic snapshot time for a resource, it is typically effective immediately except under the
 * following conditions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * If an automatic snapshot has been created for the current day, and you change the snapshot time to a later time of
 * day, then the new snapshot time will be effective the following day. This ensures that two snapshots are not created
 * for the current day.
 * </p>
 * </li>
 * <li>
 * <p>
 * If an automatic snapshot has not yet been created for the current day, and you change the snapshot time to an earlier
 * time of day, then the new snapshot time will be effective the following day and a snapshot is automatically created
 * at the previously set time for the current day. This ensures that a snapshot is created for the current day.
 * </p>
 * </li>
 * <li>
 * <p>
 * If an automatic snapshot has not yet been created for the current day, and you change the snapshot time to a time
 * that is within 30 minutes from your current time, then the new snapshot time will be effective the following day and
 * a snapshot is automatically created at the previously set time for the current day. This ensures that a snapshot is
 * created for the current day, because 30 minutes is required between your current time and the new snapshot time that
 * you specify.
 * </p>
 * </li>
 * <li>
 * <p>
 * If an automatic snapshot is scheduled to be created within 30 minutes from your current time and you change the
 * snapshot time, then the new snapshot time will be effective the following day and a snapshot is automatically created
 * at the previously set time for the current day. This ensures that a snapshot is created for the current day, because
 * 30 minutes is required between your current time and the new snapshot time that you specify.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoSnapshotAddOnRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoSnapshotAddOnRequest.Builder, AutoSnapshotAddOnRequest> {
    private static final SdkField<String> SNAPSHOT_TIME_OF_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotTimeOfDay").getter(getter(AutoSnapshotAddOnRequest::snapshotTimeOfDay))
            .setter(setter(Builder::snapshotTimeOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotTimeOfDay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_TIME_OF_DAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotTimeOfDay;

    private AutoSnapshotAddOnRequest(BuilderImpl builder) {
        this.snapshotTimeOfDay = builder.snapshotTimeOfDay;
    }

    /**
     * <p>
     * The daily time when an automatic snapshot will be created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in <code>HH:00</code> format, and in an hourly increment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot will be automatically created between the time specified and up to 45 minutes after.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time when an automatic snapshot will be created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in <code>HH:00</code> format, and in an hourly increment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The snapshot will be automatically created between the time specified and up to 45 minutes after.
     *         </p>
     *         </li>
     */
    public final String snapshotTimeOfDay() {
        return snapshotTimeOfDay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTimeOfDay());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoSnapshotAddOnRequest)) {
            return false;
        }
        AutoSnapshotAddOnRequest other = (AutoSnapshotAddOnRequest) obj;
        return Objects.equals(snapshotTimeOfDay(), other.snapshotTimeOfDay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoSnapshotAddOnRequest").add("SnapshotTimeOfDay", snapshotTimeOfDay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snapshotTimeOfDay":
            return Optional.ofNullable(clazz.cast(snapshotTimeOfDay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoSnapshotAddOnRequest, T> g) {
        return obj -> g.apply((AutoSnapshotAddOnRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoSnapshotAddOnRequest> {
        /**
         * <p>
         * The daily time when an automatic snapshot will be created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in <code>HH:00</code> format, and in an hourly increment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * The snapshot will be automatically created between the time specified and up to 45 minutes after.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotTimeOfDay
         *        The daily time when an automatic snapshot will be created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in <code>HH:00</code> format, and in an hourly increment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The snapshot will be automatically created between the time specified and up to 45 minutes after.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTimeOfDay(String snapshotTimeOfDay);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotTimeOfDay;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoSnapshotAddOnRequest model) {
            snapshotTimeOfDay(model.snapshotTimeOfDay);
        }

        public final String getSnapshotTimeOfDay() {
            return snapshotTimeOfDay;
        }

        public final void setSnapshotTimeOfDay(String snapshotTimeOfDay) {
            this.snapshotTimeOfDay = snapshotTimeOfDay;
        }

        @Override
        public final Builder snapshotTimeOfDay(String snapshotTimeOfDay) {
            this.snapshotTimeOfDay = snapshotTimeOfDay;
            return this;
        }

        @Override
        public AutoSnapshotAddOnRequest build() {
            return new AutoSnapshotAddOnRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
