/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdentityProviderSettingsRequest extends LicenseManagerUserSubscriptionsRequest implements
        ToCopyableBuilder<UpdateIdentityProviderSettingsRequest.Builder, UpdateIdentityProviderSettingsRequest> {
    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(UpdateIdentityProviderSettingsRequest::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(UpdateIdentityProviderSettingsRequest::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<UpdateSettings> UPDATE_SETTINGS_FIELD = SdkField
            .<UpdateSettings> builder(MarshallingType.SDK_POJO).memberName("UpdateSettings")
            .getter(getter(UpdateIdentityProviderSettingsRequest::updateSettings)).setter(setter(Builder::updateSettings))
            .constructor(UpdateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_FIELD,
            PRODUCT_FIELD, UPDATE_SETTINGS_FIELD));

    private final IdentityProvider identityProvider;

    private final String product;

    private final UpdateSettings updateSettings;

    private UpdateIdentityProviderSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.identityProvider = builder.identityProvider;
        this.product = builder.product;
        this.updateSettings = builder.updateSettings;
    }

    /**
     * Returns the value of the IdentityProvider property for this object.
     * 
     * @return The value of the IdentityProvider property for this object.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    /**
     * <p>
     * The name of the user-based subscription product.
     * </p>
     * 
     * @return The name of the user-based subscription product.
     */
    public final String product() {
        return product;
    }

    /**
     * <p>
     * Updates the registered identity provider’s product related configuration settings. You can update any combination
     * of settings in a single operation such as the:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Subnets which you want to add to provision VPC endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * Subnets which you want to remove the VPC endpoints from.
     * </p>
     * </li>
     * <li>
     * <p>
     * Security group ID which permits traffic to the VPC endpoints.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Updates the registered identity provider’s product related configuration settings. You can update any
     *         combination of settings in a single operation such as the:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Subnets which you want to add to provision VPC endpoints.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Subnets which you want to remove the VPC endpoints from.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Security group ID which permits traffic to the VPC endpoints.
     *         </p>
     *         </li>
     */
    public final UpdateSettings updateSettings() {
        return updateSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(updateSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityProviderSettingsRequest)) {
            return false;
        }
        UpdateIdentityProviderSettingsRequest other = (UpdateIdentityProviderSettingsRequest) obj;
        return Objects.equals(identityProvider(), other.identityProvider()) && Objects.equals(product(), other.product())
                && Objects.equals(updateSettings(), other.updateSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdentityProviderSettingsRequest").add("IdentityProvider", identityProvider())
                .add("Product", product()).add("UpdateSettings", updateSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "UpdateSettings":
            return Optional.ofNullable(clazz.cast(updateSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentityProviderSettingsRequest, T> g) {
        return obj -> g.apply((UpdateIdentityProviderSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerUserSubscriptionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdentityProviderSettingsRequest> {
        /**
         * Sets the value of the IdentityProvider property for this object.
         *
         * @param identityProvider
         *        The new value for the IdentityProvider property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * Sets the value of the IdentityProvider property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }

        /**
         * <p>
         * The name of the user-based subscription product.
         * </p>
         * 
         * @param product
         *        The name of the user-based subscription product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);

        /**
         * <p>
         * Updates the registered identity provider’s product related configuration settings. You can update any
         * combination of settings in a single operation such as the:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Subnets which you want to add to provision VPC endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * Subnets which you want to remove the VPC endpoints from.
         * </p>
         * </li>
         * <li>
         * <p>
         * Security group ID which permits traffic to the VPC endpoints.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateSettings
         *        Updates the registered identity provider’s product related configuration settings. You can update any
         *        combination of settings in a single operation such as the:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Subnets which you want to add to provision VPC endpoints.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Subnets which you want to remove the VPC endpoints from.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Security group ID which permits traffic to the VPC endpoints.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateSettings(UpdateSettings updateSettings);

        /**
         * <p>
         * Updates the registered identity provider’s product related configuration settings. You can update any
         * combination of settings in a single operation such as the:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Subnets which you want to add to provision VPC endpoints.
         * </p>
         * </li>
         * <li>
         * <p>
         * Subnets which you want to remove the VPC endpoints from.
         * </p>
         * </li>
         * <li>
         * <p>
         * Security group ID which permits traffic to the VPC endpoints.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link UpdateSettings.Builder} avoiding the need
         * to create one manually via {@link UpdateSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #updateSettings(UpdateSettings)}.
         * 
         * @param updateSettings
         *        a consumer that will call methods on {@link UpdateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateSettings(UpdateSettings)
         */
        default Builder updateSettings(Consumer<UpdateSettings.Builder> updateSettings) {
            return updateSettings(UpdateSettings.builder().applyMutation(updateSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerUserSubscriptionsRequest.BuilderImpl implements Builder {
        private IdentityProvider identityProvider;

        private String product;

        private UpdateSettings updateSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityProviderSettingsRequest model) {
            super(model);
            identityProvider(model.identityProvider);
            product(model.product);
            updateSettings(model.updateSettings);
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final String getProduct() {
            return product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final UpdateSettings.Builder getUpdateSettings() {
            return updateSettings != null ? updateSettings.toBuilder() : null;
        }

        public final void setUpdateSettings(UpdateSettings.BuilderImpl updateSettings) {
            this.updateSettings = updateSettings != null ? updateSettings.build() : null;
        }

        @Override
        public final Builder updateSettings(UpdateSettings updateSettings) {
            this.updateSettings = updateSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentityProviderSettingsRequest build() {
            return new UpdateIdentityProviderSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
