/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputMode {
    TEXT("Text"),
    SPEECH("Speech"),
    DTMF("DTMF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputMode> VALUE_MAP;
    private final String value;

    private InputMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputMode> knownValues() {
        EnumSet<InputMode> knownValues = EnumSet.allOf(InputMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputMode.class, InputMode::toString);
    }
}

