/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model.startconversationresponseeventstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.lexruntimev2.model.AudioResponseEvent;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseEventStream;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.lexruntimev2.model.AudioResponseEvent} that represents the
 * {@code StartConversationResponseEventStream$AudioResponseEvent} event. Do not use this class directly. Instead, use
 * the static builder methods on
 * {@link software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseEventStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultAudioResponseEvent extends AudioResponseEvent {
    private static final long serialVersionUID = 1L;

    DefaultAudioResponseEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(StartConversationResponseHandler.Visitor visitor) {
        visitor.visitAudioResponseEvent(this);
    }

    @Override
    public StartConversationResponseEventStream.EventType sdkEventType() {
        return StartConversationResponseEventStream.EventType.AUDIO_RESPONSE_EVENT;
    }

    public interface Builder extends AudioResponseEvent.Builder {
        @Override
        DefaultAudioResponseEvent build();
    }

    private static final class BuilderImpl extends AudioResponseEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultAudioResponseEvent event) {
            super(event);
        }

        @Override
        public DefaultAudioResponseEvent build() {
            return new DefaultAudioResponseEvent(this);
        }
    }
}
