/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse;

public class ListUtteranceAnalyticsDataIterable
implements SdkIterable<ListUtteranceAnalyticsDataResponse> {
    private final LexModelsV2Client client;
    private final ListUtteranceAnalyticsDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUtteranceAnalyticsDataIterable(LexModelsV2Client client, ListUtteranceAnalyticsDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUtteranceAnalyticsDataResponseFetcher();
    }

    public Iterator<ListUtteranceAnalyticsDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListUtteranceAnalyticsDataResponseFetcher
    implements SyncPageFetcher<ListUtteranceAnalyticsDataResponse> {
        private ListUtteranceAnalyticsDataResponseFetcher() {
        }

        public boolean hasNextPage(ListUtteranceAnalyticsDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUtteranceAnalyticsDataResponse nextPage(ListUtteranceAnalyticsDataResponse previousPage) {
            if (previousPage == null) {
                return ListUtteranceAnalyticsDataIterable.this.client.listUtteranceAnalyticsData(ListUtteranceAnalyticsDataIterable.this.firstRequest);
            }
            return ListUtteranceAnalyticsDataIterable.this.client.listUtteranceAnalyticsData((ListUtteranceAnalyticsDataRequest)((Object)ListUtteranceAnalyticsDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

