/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionSetting> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(EncryptionSetting.getter(EncryptionSetting::kmsKeyArn)).setter(EncryptionSetting.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> BOT_LOCALE_EXPORT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botLocaleExportPassword").getter(EncryptionSetting.getter(EncryptionSetting::botLocaleExportPassword)).setter(EncryptionSetting.setter(Builder::botLocaleExportPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleExportPassword").build()}).build();
    private static final SdkField<String> ASSOCIATED_TRANSCRIPTS_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedTranscriptsPassword").getter(EncryptionSetting.getter(EncryptionSetting::associatedTranscriptsPassword)).setter(EncryptionSetting.setter(Builder::associatedTranscriptsPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedTranscriptsPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD, BOT_LOCALE_EXPORT_PASSWORD_FIELD, ASSOCIATED_TRANSCRIPTS_PASSWORD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyArn;
    private final String botLocaleExportPassword;
    private final String associatedTranscriptsPassword;

    private EncryptionSetting(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.botLocaleExportPassword = builder.botLocaleExportPassword;
        this.associatedTranscriptsPassword = builder.associatedTranscriptsPassword;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String botLocaleExportPassword() {
        return this.botLocaleExportPassword;
    }

    public final String associatedTranscriptsPassword() {
        return this.associatedTranscriptsPassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.botLocaleExportPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedTranscriptsPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionSetting)) {
            return false;
        }
        EncryptionSetting other = (EncryptionSetting)obj;
        return Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.botLocaleExportPassword(), other.botLocaleExportPassword()) && Objects.equals(this.associatedTranscriptsPassword(), other.associatedTranscriptsPassword());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionSetting").add("KmsKeyArn", (Object)this.kmsKeyArn()).add("BotLocaleExportPassword", (Object)(this.botLocaleExportPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("AssociatedTranscriptsPassword", (Object)(this.associatedTranscriptsPassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "botLocaleExportPassword": {
                return Optional.ofNullable(clazz.cast(this.botLocaleExportPassword()));
            }
            case "associatedTranscriptsPassword": {
                return Optional.ofNullable(clazz.cast(this.associatedTranscriptsPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionSetting, T> g) {
        return obj -> g.apply((EncryptionSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyArn;
        private String botLocaleExportPassword;
        private String associatedTranscriptsPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionSetting model) {
            this.kmsKeyArn(model.kmsKeyArn);
            this.botLocaleExportPassword(model.botLocaleExportPassword);
            this.associatedTranscriptsPassword(model.associatedTranscriptsPassword);
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getBotLocaleExportPassword() {
            return this.botLocaleExportPassword;
        }

        public final void setBotLocaleExportPassword(String botLocaleExportPassword) {
            this.botLocaleExportPassword = botLocaleExportPassword;
        }

        @Override
        public final Builder botLocaleExportPassword(String botLocaleExportPassword) {
            this.botLocaleExportPassword = botLocaleExportPassword;
            return this;
        }

        public final String getAssociatedTranscriptsPassword() {
            return this.associatedTranscriptsPassword;
        }

        public final void setAssociatedTranscriptsPassword(String associatedTranscriptsPassword) {
            this.associatedTranscriptsPassword = associatedTranscriptsPassword;
        }

        @Override
        public final Builder associatedTranscriptsPassword(String associatedTranscriptsPassword) {
            this.associatedTranscriptsPassword = associatedTranscriptsPassword;
            return this;
        }

        public EncryptionSetting build() {
            return new EncryptionSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionSetting> {
        public Builder kmsKeyArn(String var1);

        public Builder botLocaleExportPassword(String var1);

        public Builder associatedTranscriptsPassword(String var1);
    }
}

