/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalyticsInterval {
    ONE_HOUR("OneHour"),
    ONE_DAY("OneDay"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalyticsInterval> VALUE_MAP;
    private final String value;

    private AnalyticsInterval(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalyticsInterval fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalyticsInterval> knownValues() {
        EnumSet<AnalyticsInterval> knownValues = EnumSet.allOf(AnalyticsInterval.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalyticsInterval.class, AnalyticsInterval::toString);
    }
}

