/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about the test set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSetSummary implements SdkPojo, Serializable, ToCopyableBuilder<TestSetSummary.Builder, TestSetSummary> {
    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetId").getter(getter(TestSetSummary::testSetId)).setter(setter(Builder::testSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()).build();

    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetName").getter(getter(TestSetSummary::testSetName)).setter(setter(Builder::testSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TestSetSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MODALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modality").getter(getter(TestSetSummary::modalityAsString)).setter(setter(Builder::modality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modality").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestSetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(TestSetSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Integer> NUM_TURNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numTurns").getter(getter(TestSetSummary::numTurns)).setter(setter(Builder::numTurns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numTurns").build()).build();

    private static final SdkField<TestSetStorageLocation> STORAGE_LOCATION_FIELD = SdkField
            .<TestSetStorageLocation> builder(MarshallingType.SDK_POJO).memberName("storageLocation")
            .getter(getter(TestSetSummary::storageLocation)).setter(setter(Builder::storageLocation))
            .constructor(TestSetStorageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(TestSetSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(TestSetSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_ID_FIELD,
            TEST_SET_NAME_FIELD, DESCRIPTION_FIELD, MODALITY_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, NUM_TURNS_FIELD,
            STORAGE_LOCATION_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String testSetId;

    private final String testSetName;

    private final String description;

    private final String modality;

    private final String status;

    private final String roleArn;

    private final Integer numTurns;

    private final TestSetStorageLocation storageLocation;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private TestSetSummary(BuilderImpl builder) {
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.description = builder.description;
        this.modality = builder.modality;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.numTurns = builder.numTurns;
        this.storageLocation = builder.storageLocation;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier of the test set.
     * </p>
     * 
     * @return The unique identifier of the test set.
     */
    public final String testSetId() {
        return testSetId;
    }

    /**
     * <p>
     * The name of the test set.
     * </p>
     * 
     * @return The name of the test set.
     */
    public final String testSetName() {
        return testSetName;
    }

    /**
     * <p>
     * The description of the test set.
     * </p>
     * 
     * @return The description of the test set.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the test set contains written or spoken data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modality} will
     * return {@link TestSetModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modalityAsString}.
     * </p>
     * 
     * @return Specifies whether the test set contains written or spoken data.
     * @see TestSetModality
     */
    public final TestSetModality modality() {
        return TestSetModality.fromValue(modality);
    }

    /**
     * <p>
     * Specifies whether the test set contains written or spoken data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modality} will
     * return {@link TestSetModality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modalityAsString}.
     * </p>
     * 
     * @return Specifies whether the test set contains written or spoken data.
     * @see TestSetModality
     */
    public final String modalityAsString() {
        return modality;
    }

    /**
     * <p>
     * The status of the test set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test set.
     * @see TestSetStatus
     */
    public final TestSetStatus status() {
        return TestSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the test set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test set.
     * @see TestSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The number of turns in the test set.
     * </p>
     * 
     * @return The number of turns in the test set.
     */
    public final Integer numTurns() {
        return numTurns;
    }

    /**
     * <p>
     * Contains information about the location at which the test set is stored.
     * </p>
     * 
     * @return Contains information about the location at which the test set is stored.
     */
    public final TestSetStorageLocation storageLocation() {
        return storageLocation;
    }

    /**
     * <p>
     * The date and time at which the test set was created.
     * </p>
     * 
     * @return The date and time at which the test set was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time at which the test set was last updated.
     * </p>
     * 
     * @return The date and time at which the test set was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(modalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(numTurns());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetSummary)) {
            return false;
        }
        TestSetSummary other = (TestSetSummary) obj;
        return Objects.equals(testSetId(), other.testSetId()) && Objects.equals(testSetName(), other.testSetName())
                && Objects.equals(description(), other.description())
                && Objects.equals(modalityAsString(), other.modalityAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(numTurns(), other.numTurns()) && Objects.equals(storageLocation(), other.storageLocation())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSetSummary").add("TestSetId", testSetId()).add("TestSetName", testSetName())
                .add("Description", description()).add("Modality", modalityAsString()).add("Status", statusAsString())
                .add("RoleArn", roleArn()).add("NumTurns", numTurns()).add("StorageLocation", storageLocation())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetId":
            return Optional.ofNullable(clazz.cast(testSetId()));
        case "testSetName":
            return Optional.ofNullable(clazz.cast(testSetName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "modality":
            return Optional.ofNullable(clazz.cast(modalityAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "numTurns":
            return Optional.ofNullable(clazz.cast(numTurns()));
        case "storageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestSetSummary, T> g) {
        return obj -> g.apply((TestSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSetSummary> {
        /**
         * <p>
         * The unique identifier of the test set.
         * </p>
         * 
         * @param testSetId
         *        The unique identifier of the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetId(String testSetId);

        /**
         * <p>
         * The name of the test set.
         * </p>
         * 
         * @param testSetName
         *        The name of the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetName(String testSetName);

        /**
         * <p>
         * The description of the test set.
         * </p>
         * 
         * @param description
         *        The description of the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the test set contains written or spoken data.
         * </p>
         * 
         * @param modality
         *        Specifies whether the test set contains written or spoken data.
         * @see TestSetModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetModality
         */
        Builder modality(String modality);

        /**
         * <p>
         * Specifies whether the test set contains written or spoken data.
         * </p>
         * 
         * @param modality
         *        Specifies whether the test set contains written or spoken data.
         * @see TestSetModality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetModality
         */
        Builder modality(TestSetModality modality);

        /**
         * <p>
         * The status of the test set.
         * </p>
         * 
         * @param status
         *        The status of the test set.
         * @see TestSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test set.
         * </p>
         * 
         * @param status
         *        The status of the test set.
         * @see TestSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSetStatus
         */
        Builder status(TestSetStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The number of turns in the test set.
         * </p>
         * 
         * @param numTurns
         *        The number of turns in the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numTurns(Integer numTurns);

        /**
         * <p>
         * Contains information about the location at which the test set is stored.
         * </p>
         * 
         * @param storageLocation
         *        Contains information about the location at which the test set is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(TestSetStorageLocation storageLocation);

        /**
         * <p>
         * Contains information about the location at which the test set is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSetStorageLocation.Builder} avoiding
         * the need to create one manually via {@link TestSetStorageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetStorageLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #storageLocation(TestSetStorageLocation)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link TestSetStorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(TestSetStorageLocation)
         */
        default Builder storageLocation(Consumer<TestSetStorageLocation.Builder> storageLocation) {
            return storageLocation(TestSetStorageLocation.builder().applyMutation(storageLocation).build());
        }

        /**
         * <p>
         * The date and time at which the test set was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time at which the test set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time at which the test set was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time at which the test set was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String testSetId;

        private String testSetName;

        private String description;

        private String modality;

        private String status;

        private String roleArn;

        private Integer numTurns;

        private TestSetStorageLocation storageLocation;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetSummary model) {
            testSetId(model.testSetId);
            testSetName(model.testSetName);
            description(model.description);
            modality(model.modality);
            status(model.status);
            roleArn(model.roleArn);
            numTurns(model.numTurns);
            storageLocation(model.storageLocation);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getTestSetId() {
            return testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getModality() {
            return modality;
        }

        public final void setModality(String modality) {
            this.modality = modality;
        }

        @Override
        public final Builder modality(String modality) {
            this.modality = modality;
            return this;
        }

        @Override
        public final Builder modality(TestSetModality modality) {
            this.modality(modality == null ? null : modality.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getNumTurns() {
            return numTurns;
        }

        public final void setNumTurns(Integer numTurns) {
            this.numTurns = numTurns;
        }

        @Override
        public final Builder numTurns(Integer numTurns) {
            this.numTurns = numTurns;
            return this;
        }

        public final TestSetStorageLocation.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(TestSetStorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(TestSetStorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public TestSetSummary build() {
            return new TestSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
