/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifications for the constituent sub slots and the expression for the composite slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubSlotSetting implements SdkPojo, Serializable, ToCopyableBuilder<SubSlotSetting.Builder, SubSlotSetting> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(SubSlotSetting::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<Map<String, Specifications>> SLOT_SPECIFICATIONS_FIELD = SdkField
            .<Map<String, Specifications>> builder(MarshallingType.MAP)
            .memberName("slotSpecifications")
            .getter(getter(SubSlotSetting::slotSpecifications))
            .setter(setter(Builder::slotSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotSpecifications").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Specifications> builder(MarshallingType.SDK_POJO)
                                            .constructor(Specifications::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            SLOT_SPECIFICATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final Map<String, Specifications> slotSpecifications;

    private SubSlotSetting(BuilderImpl builder) {
        this.expression = builder.expression;
        this.slotSpecifications = builder.slotSpecifications;
    }

    /**
     * <p>
     * The expression text for defining the constituent sub slots in the composite slot using logical AND and OR
     * operators.
     * </p>
     * 
     * @return The expression text for defining the constituent sub slots in the composite slot using logical AND and OR
     *         operators.
     */
    public final String expression() {
        return expression;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlotSpecifications() {
        return slotSpecifications != null && !(slotSpecifications instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifications for the constituent sub slots of a composite slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotSpecifications} method.
     * </p>
     * 
     * @return Specifications for the constituent sub slots of a composite slot.
     */
    public final Map<String, Specifications> slotSpecifications() {
        return slotSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotSpecifications() ? slotSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubSlotSetting)) {
            return false;
        }
        SubSlotSetting other = (SubSlotSetting) obj;
        return Objects.equals(expression(), other.expression()) && hasSlotSpecifications() == other.hasSlotSpecifications()
                && Objects.equals(slotSpecifications(), other.slotSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubSlotSetting").add("Expression", expression())
                .add("SlotSpecifications", hasSlotSpecifications() ? slotSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "slotSpecifications":
            return Optional.ofNullable(clazz.cast(slotSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubSlotSetting, T> g) {
        return obj -> g.apply((SubSlotSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubSlotSetting> {
        /**
         * <p>
         * The expression text for defining the constituent sub slots in the composite slot using logical AND and OR
         * operators.
         * </p>
         * 
         * @param expression
         *        The expression text for defining the constituent sub slots in the composite slot using logical AND and
         *        OR operators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * Specifications for the constituent sub slots of a composite slot.
         * </p>
         * 
         * @param slotSpecifications
         *        Specifications for the constituent sub slots of a composite slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotSpecifications(Map<String, Specifications> slotSpecifications);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private Map<String, Specifications> slotSpecifications = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubSlotSetting model) {
            expression(model.expression);
            slotSpecifications(model.slotSpecifications);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Map<String, Specifications.Builder> getSlotSpecifications() {
            Map<String, Specifications.Builder> result = SubSlotSpecificationMapCopier.copyToBuilder(this.slotSpecifications);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSlotSpecifications(Map<String, Specifications.BuilderImpl> slotSpecifications) {
            this.slotSpecifications = SubSlotSpecificationMapCopier.copyFromBuilder(slotSpecifications);
        }

        @Override
        public final Builder slotSpecifications(Map<String, Specifications> slotSpecifications) {
            this.slotSpecifications = SubSlotSpecificationMapCopier.copy(slotSpecifications);
            return this;
        }

        @Override
        public SubSlotSetting build() {
            return new SubSlotSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
