/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon S3 bucket for logging audio conversations
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketLogDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<S3BucketLogDestination.Builder, S3BucketLogDestination> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(S3BucketLogDestination::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketArn").getter(getter(S3BucketLogDestination::s3BucketArn)).setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()).build();

    private static final SdkField<String> LOG_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logPrefix").getter(getter(S3BucketLogDestination::logPrefix)).setter(setter(Builder::logPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD,
            S3_BUCKET_ARN_FIELD, LOG_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyArn;

    private final String s3BucketArn;

    private final String logPrefix;

    private S3BucketLogDestination(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.logPrefix = builder.logPrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for encrypting audio
     * log files stored in an S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for encrypting
     *         audio log files stored in an S3 bucket.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    /**
     * <p>
     * The S3 prefix to assign to audio log files.
     * </p>
     * 
     * @return The S3 prefix to assign to audio log files.
     */
    public final String logPrefix() {
        return logPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(logPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketLogDestination)) {
            return false;
        }
        S3BucketLogDestination other = (S3BucketLogDestination) obj;
        return Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(s3BucketArn(), other.s3BucketArn())
                && Objects.equals(logPrefix(), other.logPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketLogDestination").add("KmsKeyArn", kmsKeyArn()).add("S3BucketArn", s3BucketArn())
                .add("LogPrefix", logPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "s3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        case "logPrefix":
            return Optional.ofNullable(clazz.cast(logPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketLogDestination, T> g) {
        return obj -> g.apply((S3BucketLogDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketLogDestination> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for encrypting
         * audio log files stored in an S3 bucket.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for
         *        encrypting audio log files stored in an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
         * </p>
         * 
         * @param s3BucketArn
         *        The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);

        /**
         * <p>
         * The S3 prefix to assign to audio log files.
         * </p>
         * 
         * @param logPrefix
         *        The S3 prefix to assign to audio log files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPrefix(String logPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyArn;

        private String s3BucketArn;

        private String logPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketLogDestination model) {
            kmsKeyArn(model.kmsKeyArn);
            s3BucketArn(model.s3BucketArn);
            logPrefix(model.logPrefix);
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getLogPrefix() {
            return logPrefix;
        }

        public final void setLogPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        @Override
        public final Builder logPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
            return this;
        }

        @Override
        public S3BucketLogDestination build() {
            return new S3BucketLogDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
