/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that provides message text and its type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<PlainTextMessage> PLAIN_TEXT_MESSAGE_FIELD = SdkField
            .<PlainTextMessage> builder(MarshallingType.SDK_POJO).memberName("plainTextMessage")
            .getter(getter(Message::plainTextMessage)).setter(setter(Builder::plainTextMessage))
            .constructor(PlainTextMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plainTextMessage").build()).build();

    private static final SdkField<CustomPayload> CUSTOM_PAYLOAD_FIELD = SdkField
            .<CustomPayload> builder(MarshallingType.SDK_POJO).memberName("customPayload").getter(getter(Message::customPayload))
            .setter(setter(Builder::customPayload)).constructor(CustomPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPayload").build()).build();

    private static final SdkField<SSMLMessage> SSML_MESSAGE_FIELD = SdkField.<SSMLMessage> builder(MarshallingType.SDK_POJO)
            .memberName("ssmlMessage").getter(getter(Message::ssmlMessage)).setter(setter(Builder::ssmlMessage))
            .constructor(SSMLMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmlMessage").build()).build();

    private static final SdkField<ImageResponseCard> IMAGE_RESPONSE_CARD_FIELD = SdkField
            .<ImageResponseCard> builder(MarshallingType.SDK_POJO).memberName("imageResponseCard")
            .getter(getter(Message::imageResponseCard)).setter(setter(Builder::imageResponseCard))
            .constructor(ImageResponseCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageResponseCard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAIN_TEXT_MESSAGE_FIELD,
            CUSTOM_PAYLOAD_FIELD, SSML_MESSAGE_FIELD, IMAGE_RESPONSE_CARD_FIELD));

    private static final long serialVersionUID = 1L;

    private final PlainTextMessage plainTextMessage;

    private final CustomPayload customPayload;

    private final SSMLMessage ssmlMessage;

    private final ImageResponseCard imageResponseCard;

    private Message(BuilderImpl builder) {
        this.plainTextMessage = builder.plainTextMessage;
        this.customPayload = builder.customPayload;
        this.ssmlMessage = builder.ssmlMessage;
        this.imageResponseCard = builder.imageResponseCard;
    }

    /**
     * <p>
     * A message in plain text format.
     * </p>
     * 
     * @return A message in plain text format.
     */
    public final PlainTextMessage plainTextMessage() {
        return plainTextMessage;
    }

    /**
     * <p>
     * A message in a custom format defined by the client application.
     * </p>
     * 
     * @return A message in a custom format defined by the client application.
     */
    public final CustomPayload customPayload() {
        return customPayload;
    }

    /**
     * <p>
     * A message in Speech Synthesis Markup Language (SSML).
     * </p>
     * 
     * @return A message in Speech Synthesis Markup Language (SSML).
     */
    public final SSMLMessage ssmlMessage() {
        return ssmlMessage;
    }

    /**
     * <p>
     * A message that defines a response card that the client application can show to the user.
     * </p>
     * 
     * @return A message that defines a response card that the client application can show to the user.
     */
    public final ImageResponseCard imageResponseCard() {
        return imageResponseCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(plainTextMessage());
        hashCode = 31 * hashCode + Objects.hashCode(customPayload());
        hashCode = 31 * hashCode + Objects.hashCode(ssmlMessage());
        hashCode = 31 * hashCode + Objects.hashCode(imageResponseCard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(plainTextMessage(), other.plainTextMessage())
                && Objects.equals(customPayload(), other.customPayload()) && Objects.equals(ssmlMessage(), other.ssmlMessage())
                && Objects.equals(imageResponseCard(), other.imageResponseCard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Message").add("PlainTextMessage", plainTextMessage()).add("CustomPayload", customPayload())
                .add("SsmlMessage", ssmlMessage()).add("ImageResponseCard", imageResponseCard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "plainTextMessage":
            return Optional.ofNullable(clazz.cast(plainTextMessage()));
        case "customPayload":
            return Optional.ofNullable(clazz.cast(customPayload()));
        case "ssmlMessage":
            return Optional.ofNullable(clazz.cast(ssmlMessage()));
        case "imageResponseCard":
            return Optional.ofNullable(clazz.cast(imageResponseCard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * A message in plain text format.
         * </p>
         * 
         * @param plainTextMessage
         *        A message in plain text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plainTextMessage(PlainTextMessage plainTextMessage);

        /**
         * <p>
         * A message in plain text format.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlainTextMessage.Builder} avoiding the
         * need to create one manually via {@link PlainTextMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlainTextMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #plainTextMessage(PlainTextMessage)}.
         * 
         * @param plainTextMessage
         *        a consumer that will call methods on {@link PlainTextMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plainTextMessage(PlainTextMessage)
         */
        default Builder plainTextMessage(Consumer<PlainTextMessage.Builder> plainTextMessage) {
            return plainTextMessage(PlainTextMessage.builder().applyMutation(plainTextMessage).build());
        }

        /**
         * <p>
         * A message in a custom format defined by the client application.
         * </p>
         * 
         * @param customPayload
         *        A message in a custom format defined by the client application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPayload(CustomPayload customPayload);

        /**
         * <p>
         * A message in a custom format defined by the client application.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPayload.Builder} avoiding the need
         * to create one manually via {@link CustomPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #customPayload(CustomPayload)}.
         * 
         * @param customPayload
         *        a consumer that will call methods on {@link CustomPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPayload(CustomPayload)
         */
        default Builder customPayload(Consumer<CustomPayload.Builder> customPayload) {
            return customPayload(CustomPayload.builder().applyMutation(customPayload).build());
        }

        /**
         * <p>
         * A message in Speech Synthesis Markup Language (SSML).
         * </p>
         * 
         * @param ssmlMessage
         *        A message in Speech Synthesis Markup Language (SSML).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmlMessage(SSMLMessage ssmlMessage);

        /**
         * <p>
         * A message in Speech Synthesis Markup Language (SSML).
         * </p>
         * This is a convenience method that creates an instance of the {@link SSMLMessage.Builder} avoiding the need to
         * create one manually via {@link SSMLMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSMLMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #ssmlMessage(SSMLMessage)}.
         * 
         * @param ssmlMessage
         *        a consumer that will call methods on {@link SSMLMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmlMessage(SSMLMessage)
         */
        default Builder ssmlMessage(Consumer<SSMLMessage.Builder> ssmlMessage) {
            return ssmlMessage(SSMLMessage.builder().applyMutation(ssmlMessage).build());
        }

        /**
         * <p>
         * A message that defines a response card that the client application can show to the user.
         * </p>
         * 
         * @param imageResponseCard
         *        A message that defines a response card that the client application can show to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageResponseCard(ImageResponseCard imageResponseCard);

        /**
         * <p>
         * A message that defines a response card that the client application can show to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageResponseCard.Builder} avoiding the
         * need to create one manually via {@link ImageResponseCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageResponseCard.Builder#build()} is called immediately and its
         * result is passed to {@link #imageResponseCard(ImageResponseCard)}.
         * 
         * @param imageResponseCard
         *        a consumer that will call methods on {@link ImageResponseCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageResponseCard(ImageResponseCard)
         */
        default Builder imageResponseCard(Consumer<ImageResponseCard.Builder> imageResponseCard) {
            return imageResponseCard(ImageResponseCard.builder().applyMutation(imageResponseCard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PlainTextMessage plainTextMessage;

        private CustomPayload customPayload;

        private SSMLMessage ssmlMessage;

        private ImageResponseCard imageResponseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            plainTextMessage(model.plainTextMessage);
            customPayload(model.customPayload);
            ssmlMessage(model.ssmlMessage);
            imageResponseCard(model.imageResponseCard);
        }

        public final PlainTextMessage.Builder getPlainTextMessage() {
            return plainTextMessage != null ? plainTextMessage.toBuilder() : null;
        }

        public final void setPlainTextMessage(PlainTextMessage.BuilderImpl plainTextMessage) {
            this.plainTextMessage = plainTextMessage != null ? plainTextMessage.build() : null;
        }

        @Override
        public final Builder plainTextMessage(PlainTextMessage plainTextMessage) {
            this.plainTextMessage = plainTextMessage;
            return this;
        }

        public final CustomPayload.Builder getCustomPayload() {
            return customPayload != null ? customPayload.toBuilder() : null;
        }

        public final void setCustomPayload(CustomPayload.BuilderImpl customPayload) {
            this.customPayload = customPayload != null ? customPayload.build() : null;
        }

        @Override
        public final Builder customPayload(CustomPayload customPayload) {
            this.customPayload = customPayload;
            return this;
        }

        public final SSMLMessage.Builder getSsmlMessage() {
            return ssmlMessage != null ? ssmlMessage.toBuilder() : null;
        }

        public final void setSsmlMessage(SSMLMessage.BuilderImpl ssmlMessage) {
            this.ssmlMessage = ssmlMessage != null ? ssmlMessage.build() : null;
        }

        @Override
        public final Builder ssmlMessage(SSMLMessage ssmlMessage) {
            this.ssmlMessage = ssmlMessage;
            return this;
        }

        public final ImageResponseCard.Builder getImageResponseCard() {
            return imageResponseCard != null ? imageResponseCard.toBuilder() : null;
        }

        public final void setImageResponseCard(ImageResponseCard.BuilderImpl imageResponseCard) {
            this.imageResponseCard = imageResponseCard != null ? imageResponseCard.build() : null;
        }

        @Override
        public final Builder imageResponseCard(ImageResponseCard imageResponseCard) {
            this.imageResponseCard = imageResponseCard;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
