/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIntentsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListIntentsResponse.Builder, ListIntentsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListIntentsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListIntentsResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListIntentsResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<List<IntentSummary>> INTENT_SUMMARIES_FIELD = SdkField
            .<List<IntentSummary>> builder(MarshallingType.LIST)
            .memberName("intentSummaries")
            .getter(getter(ListIntentsResponse::intentSummaries))
            .setter(setter(Builder::intentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIntentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, INTENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final List<IntentSummary> intentSummaries;

    private final String nextToken;

    private ListIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.intentSummaries = builder.intentSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the bot that contains the intent.
     * </p>
     * 
     * @return The identifier of the bot that contains the intent.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the intent.
     * </p>
     * 
     * @return The version of the bot that contains the intent.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The language and locale of the intents in the list.
     * </p>
     * 
     * @return The language and locale of the intents in the list.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntentSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntentSummaries() {
        return intentSummaries != null && !(intentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the intents that meet the filter criteria specified in the request. The length of the
     * list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available,
     * the <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntentSummaries} method.
     * </p>
     * 
     * @return Summary information for the intents that meet the filter criteria specified in the request. The length of
     *         the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents
     *         available, the <code>nextToken</code> field contains a token to get the next page of results.
     */
    public final List<IntentSummary> intentSummaries() {
        return intentSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListIntents</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListIntents</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents
     *         as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIntentSummaries() ? intentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentsResponse)) {
            return false;
        }
        ListIntentsResponse other = (ListIntentsResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && hasIntentSummaries() == other.hasIntentSummaries()
                && Objects.equals(intentSummaries(), other.intentSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIntentsResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("IntentSummaries", hasIntentSummaries() ? intentSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "intentSummaries":
            return Optional.ofNullable(clazz.cast(intentSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntentsResponse, T> g) {
        return obj -> g.apply((ListIntentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListIntentsResponse> {
        /**
         * <p>
         * The identifier of the bot that contains the intent.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the intent.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The language and locale of the intents in the list.
         * </p>
         * 
         * @param localeId
         *        The language and locale of the intents in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Summary information for the intents that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more intents
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param intentSummaries
         *        Summary information for the intents that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         *        intents available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentSummaries(Collection<IntentSummary> intentSummaries);

        /**
         * <p>
         * Summary information for the intents that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more intents
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param intentSummaries
         *        Summary information for the intents that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         *        intents available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentSummaries(IntentSummary... intentSummaries);

        /**
         * <p>
         * Summary information for the intents that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more intents
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #intentSummaries(List<IntentSummary>)}.
         * 
         * @param intentSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.IntentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentSummaries(java.util.Collection<IntentSummary>)
         */
        Builder intentSummaries(Consumer<IntentSummary.Builder>... intentSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the <code>ListIntents</code>
         * operation. If the <code>nextToken</code> field is present, you send the contents as the
         * <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the
         *        contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to
         *        get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private List<IntentSummary> intentSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentsResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            intentSummaries(model.intentSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<IntentSummary.Builder> getIntentSummaries() {
            List<IntentSummary.Builder> result = IntentSummaryListCopier.copyToBuilder(this.intentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntentSummaries(Collection<IntentSummary.BuilderImpl> intentSummaries) {
            this.intentSummaries = IntentSummaryListCopier.copyFromBuilder(intentSummaries);
        }

        @Override
        public final Builder intentSummaries(Collection<IntentSummary> intentSummaries) {
            this.intentSummaries = IntentSummaryListCopier.copy(intentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentSummaries(IntentSummary... intentSummaries) {
            intentSummaries(Arrays.asList(intentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentSummaries(Consumer<IntentSummary.Builder>... intentSummaries) {
            intentSummaries(Stream.of(intentSummaries).map(c -> IntentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIntentsResponse build() {
            return new ListIntentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
