/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;

public class ListBuiltInSlotTypesIterable
implements SdkIterable<ListBuiltInSlotTypesResponse> {
    private final LexModelsV2Client client;
    private final ListBuiltInSlotTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBuiltInSlotTypesIterable(LexModelsV2Client client, ListBuiltInSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBuiltInSlotTypesResponseFetcher();
    }

    public Iterator<ListBuiltInSlotTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBuiltInSlotTypesResponseFetcher
    implements SyncPageFetcher<ListBuiltInSlotTypesResponse> {
        private ListBuiltInSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListBuiltInSlotTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBuiltInSlotTypesResponse nextPage(ListBuiltInSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return ListBuiltInSlotTypesIterable.this.client.listBuiltInSlotTypes(ListBuiltInSlotTypesIterable.this.firstRequest);
            }
            return ListBuiltInSlotTypesIterable.this.client.listBuiltInSlotTypes((ListBuiltInSlotTypesRequest)((Object)ListBuiltInSlotTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

