/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;

public class ListBotAliasesIterable
implements SdkIterable<ListBotAliasesResponse> {
    private final LexModelsV2Client client;
    private final ListBotAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotAliasesIterable(LexModelsV2Client client, ListBotAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBotAliasesResponseFetcher();
    }

    public Iterator<ListBotAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBotAliasesResponseFetcher
    implements SyncPageFetcher<ListBotAliasesResponse> {
        private ListBotAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListBotAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotAliasesResponse nextPage(ListBotAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListBotAliasesIterable.this.client.listBotAliases(ListBotAliasesIterable.this.firstRequest);
            }
            return ListBotAliasesIterable.this.client.listBotAliases((ListBotAliasesRequest)((Object)ListBotAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

