/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, StartImportResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(StartImportResponse.getter(StartImportResponse::importId)).setter(StartImportResponse.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<ImportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSpecification").getter(StartImportResponse.getter(StartImportResponse::resourceSpecification)).setter(StartImportResponse.setter(Builder::resourceSpecification)).constructor(ImportResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergeStrategy").getter(StartImportResponse.getter(StartImportResponse::mergeStrategyAsString)).setter(StartImportResponse.setter(Builder::mergeStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importStatus").getter(StartImportResponse.getter(StartImportResponse::importStatusAsString)).setter(StartImportResponse.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(StartImportResponse.getter(StartImportResponse::creationDateTime)).setter(StartImportResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, RESOURCE_SPECIFICATION_FIELD, MERGE_STRATEGY_FIELD, IMPORT_STATUS_FIELD, CREATION_DATE_TIME_FIELD));
    private final String importId;
    private final ImportResourceSpecification resourceSpecification;
    private final String mergeStrategy;
    private final String importStatus;
    private final Instant creationDateTime;

    private StartImportResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.resourceSpecification = builder.resourceSpecification;
        this.mergeStrategy = builder.mergeStrategy;
        this.importStatus = builder.importStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    public final String importId() {
        return this.importId;
    }

    public final ImportResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(this.mergeStrategy);
    }

    public final String mergeStrategyAsString() {
        return this.mergeStrategy;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportResponse)) {
            return false;
        }
        StartImportResponse other = (StartImportResponse)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.mergeStrategyAsString(), other.mergeStrategyAsString()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportResponse").add("ImportId", (Object)this.importId()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("MergeStrategy", (Object)this.mergeStrategyAsString()).add("ImportStatus", (Object)this.importStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "resourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "mergeStrategy": {
                return Optional.ofNullable(clazz.cast(this.mergeStrategyAsString()));
            }
            case "importStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportResponse, T> g) {
        return obj -> g.apply((StartImportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String importId;
        private ImportResourceSpecification resourceSpecification;
        private String mergeStrategy;
        private String importStatus;
        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportResponse model) {
            super(model);
            this.importId(model.importId);
            this.resourceSpecification(model.resourceSpecification);
            this.mergeStrategy(model.mergeStrategy);
            this.importStatus(model.importStatus);
            this.creationDateTime(model.creationDateTime);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ImportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ImportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getMergeStrategy() {
            return this.mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public StartImportResponse build() {
            return new StartImportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportResponse> {
        public Builder importId(String var1);

        public Builder resourceSpecification(ImportResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ImportResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ImportResourceSpecification)((ImportResourceSpecification.Builder)ImportResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder mergeStrategy(String var1);

        public Builder mergeStrategy(MergeStrategy var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder creationDateTime(Instant var1);
    }
}

