/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetMigrationsResponse;

public class GetMigrationsIterable
implements SdkIterable<GetMigrationsResponse> {
    private final LexModelBuildingClient client;
    private final GetMigrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetMigrationsIterable(LexModelBuildingClient client, GetMigrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetMigrationsResponseFetcher();
    }

    public Iterator<GetMigrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetMigrationsResponseFetcher
    implements SyncPageFetcher<GetMigrationsResponse> {
        private GetMigrationsResponseFetcher() {
        }

        public boolean hasNextPage(GetMigrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetMigrationsResponse nextPage(GetMigrationsResponse previousPage) {
            if (previousPage == null) {
                return GetMigrationsIterable.this.client.getMigrations(GetMigrationsIterable.this.firstRequest);
            }
            return GetMigrationsIterable.this.client.getMigrations((GetMigrationsRequest)((Object)GetMigrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

