/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse;

public class GetBotsIterable
implements SdkIterable<GetBotsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBotsIterable(LexModelBuildingClient client, GetBotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetBotsResponseFetcher();
    }

    public Iterator<GetBotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetBotsResponseFetcher
    implements SyncPageFetcher<GetBotsResponse> {
        private GetBotsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBotsResponse nextPage(GetBotsResponse previousPage) {
            if (previousPage == null) {
                return GetBotsIterable.this.client.getBots(GetBotsIterable.this.firstRequest);
            }
            return GetBotsIterable.this.client.getBots((GetBotsRequest)((Object)GetBotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

