/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventStatus {
    CANCELED("CANCELED"),
    CANCELING("CANCELING"),
    COMPLETED("COMPLETED"),
    CREATED("CREATED"),
    FAILED("FAILED"),
    IN_PROGRESS("IN_PROGRESS"),
    PENDING("PENDING"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventStatus> VALUE_MAP;
    private final String value;

    private EventStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventStatus> knownValues() {
        EnumSet<EventStatus> knownValues = EnumSet.allOf(EventStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventStatus.class, EventStatus::toString);
    }
}

