/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data associated with a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentData implements SdkPojo, Serializable, ToCopyableBuilder<DeploymentData.Builder, DeploymentData> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DeploymentData::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("deletedAt").getter(getter(DeploymentData::deletedAt)).setter(setter(Builder::deletedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedAt").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeploymentData::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeploymentData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patternName").getter(getter(DeploymentData::patternName)).setter(setter(Builder::patternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternName").build()).build();

    private static final SdkField<String> RESOURCE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGroup").getter(getter(DeploymentData::resourceGroup)).setter(setter(Builder::resourceGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroup").build()).build();

    private static final SdkField<Map<String, String>> SPECIFICATIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("specifications")
            .getter(getter(DeploymentData::specifications))
            .setter(setter(Builder::specifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specifications").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeploymentData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadName").getter(getter(DeploymentData::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DELETED_AT_FIELD, ID_FIELD, NAME_FIELD, PATTERN_NAME_FIELD, RESOURCE_GROUP_FIELD, SPECIFICATIONS_FIELD, STATUS_FIELD,
            WORKLOAD_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Instant deletedAt;

    private final String id;

    private final String name;

    private final String patternName;

    private final String resourceGroup;

    private final Map<String, String> specifications;

    private final String status;

    private final String workloadName;

    private DeploymentData(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
        this.id = builder.id;
        this.name = builder.name;
        this.patternName = builder.patternName;
        this.resourceGroup = builder.resourceGroup;
        this.specifications = builder.specifications;
        this.status = builder.status;
        this.workloadName = builder.workloadName;
    }

    /**
     * <p>
     * The time the deployment was created.
     * </p>
     * 
     * @return The time the deployment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time the deployment was deleted.
     * </p>
     * 
     * @return The time the deployment was deleted.
     */
    public final Instant deletedAt() {
        return deletedAt;
    }

    /**
     * <p>
     * The ID of the deployment.
     * </p>
     * 
     * @return The ID of the deployment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the deployment.
     * </p>
     * 
     * @return The name of the deployment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The pattern name of the deployment.
     * </p>
     * 
     * @return The pattern name of the deployment.
     */
    public final String patternName() {
        return patternName;
    }

    /**
     * <p>
     * The resource group of the deployment.
     * </p>
     * 
     * @return The resource group of the deployment.
     */
    public final String resourceGroup() {
        return resourceGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the Specifications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSpecifications() {
        return specifications != null && !(specifications instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The specifications of the deployment. For more information on specifications for each deployment, see <a
     * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications.html">Workload
     * specifications</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpecifications} method.
     * </p>
     * 
     * @return The specifications of the deployment. For more information on specifications for each deployment, see <a
     *         href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications.html">
     *         Workload specifications</a>.
     */
    public final Map<String, String> specifications() {
        return specifications;
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the workload.
     * </p>
     * 
     * @return The name of the workload.
     */
    public final String workloadName() {
        return workloadName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(patternName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpecifications() ? specifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentData)) {
            return false;
        }
        DeploymentData other = (DeploymentData) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deletedAt(), other.deletedAt())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(patternName(), other.patternName()) && Objects.equals(resourceGroup(), other.resourceGroup())
                && hasSpecifications() == other.hasSpecifications() && Objects.equals(specifications(), other.specifications())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(workloadName(), other.workloadName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentData").add("CreatedAt", createdAt()).add("DeletedAt", deletedAt()).add("Id", id())
                .add("Name", name()).add("PatternName", patternName()).add("ResourceGroup", resourceGroup())
                .add("Specifications", specifications() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("WorkloadName", workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deletedAt":
            return Optional.ofNullable(clazz.cast(deletedAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "patternName":
            return Optional.ofNullable(clazz.cast(patternName()));
        case "resourceGroup":
            return Optional.ofNullable(clazz.cast(resourceGroup()));
        case "specifications":
            return Optional.ofNullable(clazz.cast(specifications()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "workloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentData, T> g) {
        return obj -> g.apply((DeploymentData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentData> {
        /**
         * <p>
         * The time the deployment was created.
         * </p>
         * 
         * @param createdAt
         *        The time the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time the deployment was deleted.
         * </p>
         * 
         * @param deletedAt
         *        The time the deployment was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedAt(Instant deletedAt);

        /**
         * <p>
         * The ID of the deployment.
         * </p>
         * 
         * @param id
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the deployment.
         * </p>
         * 
         * @param name
         *        The name of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The pattern name of the deployment.
         * </p>
         * 
         * @param patternName
         *        The pattern name of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternName(String patternName);

        /**
         * <p>
         * The resource group of the deployment.
         * </p>
         * 
         * @param resourceGroup
         *        The resource group of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroup(String resourceGroup);

        /**
         * <p>
         * The specifications of the deployment. For more information on specifications for each deployment, see <a
         * href=
         * "https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications.html">Workload
         * specifications</a>.
         * </p>
         * 
         * @param specifications
         *        The specifications of the deployment. For more information on specifications for each deployment, see
         *        <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications.html"
         *        >Workload specifications</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifications(Map<String, String> specifications);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param status
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param status
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * The name of the workload.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Instant deletedAt;

        private String id;

        private String name;

        private String patternName;

        private String resourceGroup;

        private Map<String, String> specifications = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentData model) {
            createdAt(model.createdAt);
            deletedAt(model.deletedAt);
            id(model.id);
            name(model.name);
            patternName(model.patternName);
            resourceGroup(model.resourceGroup);
            specifications(model.specifications);
            status(model.status);
            workloadName(model.workloadName);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPatternName() {
            return patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final String getResourceGroup() {
            return resourceGroup;
        }

        public final void setResourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        @Override
        public final Builder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public final Map<String, String> getSpecifications() {
            if (specifications instanceof SdkAutoConstructMap) {
                return null;
            }
            return specifications;
        }

        public final void setSpecifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
        }

        @Override
        public final Builder specifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        @Override
        public DeploymentData build() {
            return new DeploymentData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
