/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.ImageConfig;
import software.amazon.awssdk.services.lambda.model.ImageConfigError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageConfigResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageConfigResponse> {
    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfig").getter(ImageConfigResponse.getter(ImageConfigResponse::imageConfig)).setter(ImageConfigResponse.setter(Builder::imageConfig)).constructor(ImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()}).build();
    private static final SdkField<ImageConfigError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(ImageConfigResponse.getter(ImageConfigResponse::error)).setter(ImageConfigResponse.setter(Builder::error)).constructor(ImageConfigError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_CONFIG_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final ImageConfig imageConfig;
    private final ImageConfigError error;

    private ImageConfigResponse(BuilderImpl builder) {
        this.imageConfig = builder.imageConfig;
        this.error = builder.error;
    }

    public final ImageConfig imageConfig() {
        return this.imageConfig;
    }

    public final ImageConfigError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfigResponse)) {
            return false;
        }
        ImageConfigResponse other = (ImageConfigResponse)obj;
        return Objects.equals(this.imageConfig(), other.imageConfig()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"ImageConfigResponse").add("ImageConfig", (Object)this.imageConfig()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageConfig": {
                return Optional.ofNullable(clazz.cast(this.imageConfig()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageConfigResponse, T> g) {
        return obj -> g.apply((ImageConfigResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageConfig imageConfig;
        private ImageConfigError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfigResponse model) {
            this.imageConfig(model.imageConfig);
            this.error(model.error);
        }

        public final ImageConfig.Builder getImageConfig() {
            return this.imageConfig != null ? this.imageConfig.toBuilder() : null;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final ImageConfigError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ImageConfigError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ImageConfigError error) {
            this.error = error;
            return this;
        }

        public ImageConfigResponse build() {
            return new ImageConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageConfigResponse> {
        public Builder imageConfig(ImageConfig var1);

        default public Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return this.imageConfig((ImageConfig)((ImageConfig.Builder)ImageConfig.builder().applyMutation(imageConfig)).build());
        }

        public Builder error(ImageConfigError var1);

        default public Builder error(Consumer<ImageConfigError.Builder> error) {
            return this.error((ImageConfigError)((ImageConfigError.Builder)ImageConfigError.builder().applyMutation(error)).build());
        }
    }
}

