/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountLimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountLimit> {
    private static final SdkField<Long> TOTAL_CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCodeSize").getter(AccountLimit.getter(AccountLimit::totalCodeSize)).setter(AccountLimit.setter(Builder::totalCodeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCodeSize").build()}).build();
    private static final SdkField<Long> CODE_SIZE_UNZIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CodeSizeUnzipped").getter(AccountLimit.getter(AccountLimit::codeSizeUnzipped)).setter(AccountLimit.setter(Builder::codeSizeUnzipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSizeUnzipped").build()}).build();
    private static final SdkField<Long> CODE_SIZE_ZIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CodeSizeZipped").getter(AccountLimit.getter(AccountLimit::codeSizeZipped)).setter(AccountLimit.setter(Builder::codeSizeZipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSizeZipped").build()}).build();
    private static final SdkField<Integer> CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConcurrentExecutions").getter(AccountLimit.getter(AccountLimit::concurrentExecutions)).setter(AccountLimit.setter(Builder::concurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConcurrentExecutions").build()}).build();
    private static final SdkField<Integer> UNRESERVED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnreservedConcurrentExecutions").getter(AccountLimit.getter(AccountLimit::unreservedConcurrentExecutions)).setter(AccountLimit.setter(Builder::unreservedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnreservedConcurrentExecutions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_CODE_SIZE_FIELD, CODE_SIZE_UNZIPPED_FIELD, CODE_SIZE_ZIPPED_FIELD, CONCURRENT_EXECUTIONS_FIELD, UNRESERVED_CONCURRENT_EXECUTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long totalCodeSize;
    private final Long codeSizeUnzipped;
    private final Long codeSizeZipped;
    private final Integer concurrentExecutions;
    private final Integer unreservedConcurrentExecutions;

    private AccountLimit(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.codeSizeUnzipped = builder.codeSizeUnzipped;
        this.codeSizeZipped = builder.codeSizeZipped;
        this.concurrentExecutions = builder.concurrentExecutions;
        this.unreservedConcurrentExecutions = builder.unreservedConcurrentExecutions;
    }

    public final Long totalCodeSize() {
        return this.totalCodeSize;
    }

    public final Long codeSizeUnzipped() {
        return this.codeSizeUnzipped;
    }

    public final Long codeSizeZipped() {
        return this.codeSizeZipped;
    }

    public final Integer concurrentExecutions() {
        return this.concurrentExecutions;
    }

    public final Integer unreservedConcurrentExecutions() {
        return this.unreservedConcurrentExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCodeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSizeUnzipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSizeZipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.unreservedConcurrentExecutions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLimit)) {
            return false;
        }
        AccountLimit other = (AccountLimit)obj;
        return Objects.equals(this.totalCodeSize(), other.totalCodeSize()) && Objects.equals(this.codeSizeUnzipped(), other.codeSizeUnzipped()) && Objects.equals(this.codeSizeZipped(), other.codeSizeZipped()) && Objects.equals(this.concurrentExecutions(), other.concurrentExecutions()) && Objects.equals(this.unreservedConcurrentExecutions(), other.unreservedConcurrentExecutions());
    }

    public final String toString() {
        return ToString.builder((String)"AccountLimit").add("TotalCodeSize", (Object)this.totalCodeSize()).add("CodeSizeUnzipped", (Object)this.codeSizeUnzipped()).add("CodeSizeZipped", (Object)this.codeSizeZipped()).add("ConcurrentExecutions", (Object)this.concurrentExecutions()).add("UnreservedConcurrentExecutions", (Object)this.unreservedConcurrentExecutions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalCodeSize": {
                return Optional.ofNullable(clazz.cast(this.totalCodeSize()));
            }
            case "CodeSizeUnzipped": {
                return Optional.ofNullable(clazz.cast(this.codeSizeUnzipped()));
            }
            case "CodeSizeZipped": {
                return Optional.ofNullable(clazz.cast(this.codeSizeZipped()));
            }
            case "ConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.concurrentExecutions()));
            }
            case "UnreservedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.unreservedConcurrentExecutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountLimit, T> g) {
        return obj -> g.apply((AccountLimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalCodeSize;
        private Long codeSizeUnzipped;
        private Long codeSizeZipped;
        private Integer concurrentExecutions;
        private Integer unreservedConcurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLimit model) {
            this.totalCodeSize(model.totalCodeSize);
            this.codeSizeUnzipped(model.codeSizeUnzipped);
            this.codeSizeZipped(model.codeSizeZipped);
            this.concurrentExecutions(model.concurrentExecutions);
            this.unreservedConcurrentExecutions(model.unreservedConcurrentExecutions);
        }

        public final Long getTotalCodeSize() {
            return this.totalCodeSize;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final Long getCodeSizeUnzipped() {
            return this.codeSizeUnzipped;
        }

        public final void setCodeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
        }

        @Override
        public final Builder codeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
            return this;
        }

        public final Long getCodeSizeZipped() {
            return this.codeSizeZipped;
        }

        public final void setCodeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
        }

        @Override
        public final Builder codeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
            return this;
        }

        public final Integer getConcurrentExecutions() {
            return this.concurrentExecutions;
        }

        public final void setConcurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        @Override
        public final Builder concurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public final Integer getUnreservedConcurrentExecutions() {
            return this.unreservedConcurrentExecutions;
        }

        public final void setUnreservedConcurrentExecutions(Integer unreservedConcurrentExecutions) {
            this.unreservedConcurrentExecutions = unreservedConcurrentExecutions;
        }

        @Override
        public final Builder unreservedConcurrentExecutions(Integer unreservedConcurrentExecutions) {
            this.unreservedConcurrentExecutions = unreservedConcurrentExecutions;
            return this;
        }

        public AccountLimit build() {
            return new AccountLimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountLimit> {
        public Builder totalCodeSize(Long var1);

        public Builder codeSizeUnzipped(Long var1);

        public Builder codeSizeZipped(Long var1);

        public Builder concurrentExecutions(Integer var1);

        public Builder unreservedConcurrentExecutions(Integer var1);
    }
}

