/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLayerVersionsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListLayerVersionsResponse.Builder, ListLayerVersionsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListLayerVersionsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<LayerVersionsListItem>> LAYER_VERSIONS_FIELD = SdkField
            .<List<LayerVersionsListItem>> builder(MarshallingType.LIST)
            .memberName("LayerVersions")
            .getter(getter(ListLayerVersionsResponse::layerVersions))
            .setter(setter(Builder::layerVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LayerVersionsListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(LayerVersionsListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            LAYER_VERSIONS_FIELD));

    private final String nextMarker;

    private final List<LayerVersionsListItem> layerVersions;

    private ListLayerVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.layerVersions = builder.layerVersions;
    }

    /**
     * <p>
     * A pagination token returned when the response doesn't contain all versions.
     * </p>
     * 
     * @return A pagination token returned when the response doesn't contain all versions.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the LayerVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLayerVersions() {
        return layerVersions != null && !(layerVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayerVersions} method.
     * </p>
     * 
     * @return A list of versions.
     */
    public final List<LayerVersionsListItem> layerVersions() {
        return layerVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayerVersions() ? layerVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayerVersionsResponse)) {
            return false;
        }
        ListLayerVersionsResponse other = (ListLayerVersionsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasLayerVersions() == other.hasLayerVersions()
                && Objects.equals(layerVersions(), other.layerVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLayerVersionsResponse").add("NextMarker", nextMarker())
                .add("LayerVersions", hasLayerVersions() ? layerVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "LayerVersions":
            return Optional.ofNullable(clazz.cast(layerVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLayerVersionsResponse, T> g) {
        return obj -> g.apply((ListLayerVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLayerVersionsResponse> {
        /**
         * <p>
         * A pagination token returned when the response doesn't contain all versions.
         * </p>
         * 
         * @param nextMarker
         *        A pagination token returned when the response doesn't contain all versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * A list of versions.
         * </p>
         * 
         * @param layerVersions
         *        A list of versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerVersions(Collection<LayerVersionsListItem> layerVersions);

        /**
         * <p>
         * A list of versions.
         * </p>
         * 
         * @param layerVersions
         *        A list of versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerVersions(LayerVersionsListItem... layerVersions);

        /**
         * <p>
         * A list of versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.LayerVersionsListItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lambda.model.LayerVersionsListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.LayerVersionsListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #layerVersions(List<LayerVersionsListItem>)}.
         * 
         * @param layerVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.LayerVersionsListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layerVersions(java.util.Collection<LayerVersionsListItem>)
         */
        Builder layerVersions(Consumer<LayerVersionsListItem.Builder>... layerVersions);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<LayerVersionsListItem> layerVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayerVersionsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            layerVersions(model.layerVersions);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<LayerVersionsListItem.Builder> getLayerVersions() {
            List<LayerVersionsListItem.Builder> result = LayerVersionsListCopier.copyToBuilder(this.layerVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayerVersions(Collection<LayerVersionsListItem.BuilderImpl> layerVersions) {
            this.layerVersions = LayerVersionsListCopier.copyFromBuilder(layerVersions);
        }

        @Override
        public final Builder layerVersions(Collection<LayerVersionsListItem> layerVersions) {
            this.layerVersions = LayerVersionsListCopier.copy(layerVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerVersions(LayerVersionsListItem... layerVersions) {
            layerVersions(Arrays.asList(layerVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerVersions(Consumer<LayerVersionsListItem.Builder>... layerVersions) {
            layerVersions(Stream.of(layerVersions).map(c -> LayerVersionsListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListLayerVersionsResponse build() {
            return new ListLayerVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
