/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure describing a database resource with LF-tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaggedDatabase implements SdkPojo, Serializable, ToCopyableBuilder<TaggedDatabase.Builder, TaggedDatabase> {
    private static final SdkField<DatabaseResource> DATABASE_FIELD = SdkField
            .<DatabaseResource> builder(MarshallingType.SDK_POJO).memberName("Database").getter(getter(TaggedDatabase::database))
            .setter(setter(Builder::database)).constructor(DatabaseResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<List<LFTagPair>> LF_TAGS_FIELD = SdkField
            .<List<LFTagPair>> builder(MarshallingType.LIST)
            .memberName("LFTags")
            .getter(getter(TaggedDatabase::lfTags))
            .setter(setter(Builder::lfTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LFTagPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(LFTagPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DATABASE_FIELD, LF_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DatabaseResource database;

    private final List<LFTagPair> lfTags;

    private TaggedDatabase(BuilderImpl builder) {
        this.database = builder.database;
        this.lfTags = builder.lfTags;
    }

    /**
     * <p>
     * A database that has LF-tags attached to it.
     * </p>
     * 
     * @return A database that has LF-tags attached to it.
     */
    public final DatabaseResource database() {
        return database;
    }

    /**
     * For responses, this returns true if the service returned a value for the LFTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLfTags() {
        return lfTags != null && !(lfTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of LF-tags attached to the database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLfTags} method.
     * </p>
     * 
     * @return A list of LF-tags attached to the database.
     */
    public final List<LFTagPair> lfTags() {
        return lfTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(hasLfTags() ? lfTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaggedDatabase)) {
            return false;
        }
        TaggedDatabase other = (TaggedDatabase) obj;
        return Objects.equals(database(), other.database()) && hasLfTags() == other.hasLfTags()
                && Objects.equals(lfTags(), other.lfTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaggedDatabase").add("Database", database()).add("LFTags", hasLfTags() ? lfTags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "LFTags":
            return Optional.ofNullable(clazz.cast(lfTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaggedDatabase, T> g) {
        return obj -> g.apply((TaggedDatabase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaggedDatabase> {
        /**
         * <p>
         * A database that has LF-tags attached to it.
         * </p>
         * 
         * @param database
         *        A database that has LF-tags attached to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(DatabaseResource database);

        /**
         * <p>
         * A database that has LF-tags attached to it.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabaseResource.Builder} avoiding the
         * need to create one manually via {@link DatabaseResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseResource.Builder#build()} is called immediately and its
         * result is passed to {@link #database(DatabaseResource)}.
         * 
         * @param database
         *        a consumer that will call methods on {@link DatabaseResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #database(DatabaseResource)
         */
        default Builder database(Consumer<DatabaseResource.Builder> database) {
            return database(DatabaseResource.builder().applyMutation(database).build());
        }

        /**
         * <p>
         * A list of LF-tags attached to the database.
         * </p>
         * 
         * @param lfTags
         *        A list of LF-tags attached to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTags(Collection<LFTagPair> lfTags);

        /**
         * <p>
         * A list of LF-tags attached to the database.
         * </p>
         * 
         * @param lfTags
         *        A list of LF-tags attached to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTags(LFTagPair... lfTags);

        /**
         * <p>
         * A list of LF-tags attached to the database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.LFTagPair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lakeformation.model.LFTagPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.LFTagPair.Builder#build()} is called immediately
         * and its result is passed to {@link #lfTags(List<LFTagPair>)}.
         * 
         * @param lfTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.LFTagPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTags(java.util.Collection<LFTagPair>)
         */
        Builder lfTags(Consumer<LFTagPair.Builder>... lfTags);
    }

    static final class BuilderImpl implements Builder {
        private DatabaseResource database;

        private List<LFTagPair> lfTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaggedDatabase model) {
            database(model.database);
            lfTags(model.lfTags);
        }

        public final DatabaseResource.Builder getDatabase() {
            return database != null ? database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseResource.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        public final Builder database(DatabaseResource database) {
            this.database = database;
            return this;
        }

        public final List<LFTagPair.Builder> getLfTags() {
            List<LFTagPair.Builder> result = LFTagsListCopier.copyToBuilder(this.lfTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTags(Collection<LFTagPair.BuilderImpl> lfTags) {
            this.lfTags = LFTagsListCopier.copyFromBuilder(lfTags);
        }

        @Override
        public final Builder lfTags(Collection<LFTagPair> lfTags) {
            this.lfTags = LFTagsListCopier.copy(lfTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(LFTagPair... lfTags) {
            lfTags(Arrays.asList(lfTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(Consumer<LFTagPair.Builder>... lfTags) {
            lfTags(Stream.of(lfTags).map(c -> LFTagPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TaggedDatabase build() {
            return new TaggedDatabase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
