/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitRange;

public class GetWorkUnitsIterable
implements SdkIterable<GetWorkUnitsResponse> {
    private final LakeFormationClient client;
    private final GetWorkUnitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetWorkUnitsIterable(LakeFormationClient client, GetWorkUnitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetWorkUnitsResponseFetcher();
    }

    public Iterator<GetWorkUnitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkUnitRange> workUnitRanges() {
        Function<GetWorkUnitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workUnitRanges() != null) {
                return response.workUnitRanges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetWorkUnitsResponseFetcher
    implements SyncPageFetcher<GetWorkUnitsResponse> {
        private GetWorkUnitsResponseFetcher() {
        }

        public boolean hasNextPage(GetWorkUnitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetWorkUnitsResponse nextPage(GetWorkUnitsResponse previousPage) {
            if (previousPage == null) {
                return GetWorkUnitsIterable.this.client.getWorkUnits(GetWorkUnitsIterable.this.firstRequest);
            }
            return GetWorkUnitsIterable.this.client.getWorkUnits((GetWorkUnitsRequest)((Object)GetWorkUnitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

