/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaAsyncClient;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Image;

public class GetImagesPublisher
implements SdkPublisher<GetImagesResponse> {
    private final KinesisVideoArchivedMediaAsyncClient client;
    private final GetImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetImagesPublisher(KinesisVideoArchivedMediaAsyncClient client, GetImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetImagesPublisher(KinesisVideoArchivedMediaAsyncClient client, GetImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Image> images() {
        Function<GetImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.images() != null) {
                return response.images().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetImagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetImagesResponseFetcher
    implements AsyncPageFetcher<GetImagesResponse> {
        private GetImagesResponseFetcher() {
        }

        public boolean hasNextPage(GetImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetImagesResponse> nextPage(GetImagesResponse previousPage) {
            if (previousPage == null) {
                return GetImagesPublisher.this.client.getImages(GetImagesPublisher.this.firstRequest);
            }
            return GetImagesPublisher.this.client.getImages((GetImagesRequest)((Object)GetImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

