/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, PutRecordsRequest> {
    private static final SdkField<List<PutRecordsRequestEntry>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(PutRecordsRequest.getter(PutRecordsRequest::records)).setter(PutRecordsRequest.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutRecordsRequestEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(PutRecordsRequest.getter(PutRecordsRequest::streamName)).setter(PutRecordsRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(PutRecordsRequest.getter(PutRecordsRequest::streamARN)).setter(PutRecordsRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, STREAM_NAME_FIELD, STREAM_ARN_FIELD));
    private final List<PutRecordsRequestEntry> records;
    private final String streamName;
    private final String streamARN;

    private PutRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<PutRecordsRequestEntry> records() {
        return this.records;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequest)) {
            return false;
        }
        PutRecordsRequest other = (PutRecordsRequest)((Object)obj);
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecordsRequest").add("Records", this.hasRecords() ? this.records() : null).add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordsRequest, T> g) {
        return obj -> g.apply((PutRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private List<PutRecordsRequestEntry> records = DefaultSdkAutoConstructList.getInstance();
        private String streamName;
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequest model) {
            super(model);
            this.records(model.records);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
        }

        public final List<PutRecordsRequestEntry.Builder> getRecords() {
            List<PutRecordsRequestEntry.Builder> result = PutRecordsRequestEntryListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<PutRecordsRequestEntry.BuilderImpl> records) {
            this.records = PutRecordsRequestEntryListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<PutRecordsRequestEntry> records) {
            this.records = PutRecordsRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsRequestEntry ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<PutRecordsRequestEntry.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (PutRecordsRequestEntry)((PutRecordsRequestEntry.Builder)PutRecordsRequestEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordsRequest build() {
            return new PutRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordsRequest> {
        public Builder records(Collection<PutRecordsRequestEntry> var1);

        public Builder records(PutRecordsRequestEntry ... var1);

        public Builder records(Consumer<PutRecordsRequestEntry.Builder> ... var1);

        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

