/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.kendraranking.auth.scheme.KendraRankingAuthSchemeProvider;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointProvider;

/**
 * This includes configuration specific to Kendra Ranking that is supported by both {@link KendraRankingClientBuilder}
 * and {@link KendraRankingAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface KendraRankingBaseClientBuilder<B extends KendraRankingBaseClientBuilder<B, C>, C> extends AwsClientBuilder<B, C> {
    /**
     * Set the {@link KendraRankingEndpointProvider} implementation that will be used by the client to determine the
     * endpoint for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(KendraRankingEndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link KendraRankingAuthSchemeProvider} implementation that will be used by the client to resolve the
     * auth scheme for each request. This is optional; if none is provided a default implementation will be used the
     * SDK.
     */
    default B authSchemeProvider(KendraRankingAuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }
}
