/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kendraranking.DefaultKendraRankingAsyncClient;
import software.amazon.awssdk.services.kendraranking.DefaultKendraRankingBaseClientBuilder;
import software.amazon.awssdk.services.kendraranking.KendraRankingAsyncClient;
import software.amazon.awssdk.services.kendraranking.KendraRankingAsyncClientBuilder;
import software.amazon.awssdk.services.kendraranking.KendraRankingServiceClientConfiguration;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointProvider;

@SdkInternalApi
final class DefaultKendraRankingAsyncClientBuilder
extends DefaultKendraRankingBaseClientBuilder<KendraRankingAsyncClientBuilder, KendraRankingAsyncClient>
implements KendraRankingAsyncClientBuilder {
    DefaultKendraRankingAsyncClientBuilder() {
    }

    @Override
    public DefaultKendraRankingAsyncClientBuilder endpointProvider(KendraRankingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KendraRankingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKendraRankingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        KendraRankingServiceClientConfiguration serviceClientConfiguration = KendraRankingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultKendraRankingAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

