/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for suggested query spell corrections.
 * </p>
 * <p>
 * Suggested spell corrections are based on words that appear in your indexed documents and how closely a corrected word
 * matches a misspelled word.
 * </p>
 * <p>
 * This feature is designed with certain defaults or limits. For information on the current limits and how to request
 * more support for some limits, see the <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/query-spell-check.html">Spell Checker documentation</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpellCorrectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SpellCorrectionConfiguration.Builder, SpellCorrectionConfiguration> {
    private static final SdkField<Boolean> INCLUDE_QUERY_SPELL_CHECK_SUGGESTIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeQuerySpellCheckSuggestions")
            .getter(getter(SpellCorrectionConfiguration::includeQuerySpellCheckSuggestions))
            .setter(setter(Builder::includeQuerySpellCheckSuggestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeQuerySpellCheckSuggestions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INCLUDE_QUERY_SPELL_CHECK_SUGGESTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean includeQuerySpellCheckSuggestions;

    private SpellCorrectionConfiguration(BuilderImpl builder) {
        this.includeQuerySpellCheckSuggestions = builder.includeQuerySpellCheckSuggestions;
    }

    /**
     * <p>
     * <code>TRUE</code> to suggest spell corrections for queries.
     * </p>
     * 
     * @return <code>TRUE</code> to suggest spell corrections for queries.
     */
    public final Boolean includeQuerySpellCheckSuggestions() {
        return includeQuerySpellCheckSuggestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeQuerySpellCheckSuggestions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpellCorrectionConfiguration)) {
            return false;
        }
        SpellCorrectionConfiguration other = (SpellCorrectionConfiguration) obj;
        return Objects.equals(includeQuerySpellCheckSuggestions(), other.includeQuerySpellCheckSuggestions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpellCorrectionConfiguration")
                .add("IncludeQuerySpellCheckSuggestions", includeQuerySpellCheckSuggestions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeQuerySpellCheckSuggestions":
            return Optional.ofNullable(clazz.cast(includeQuerySpellCheckSuggestions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpellCorrectionConfiguration, T> g) {
        return obj -> g.apply((SpellCorrectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpellCorrectionConfiguration> {
        /**
         * <p>
         * <code>TRUE</code> to suggest spell corrections for queries.
         * </p>
         * 
         * @param includeQuerySpellCheckSuggestions
         *        <code>TRUE</code> to suggest spell corrections for queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeQuerySpellCheckSuggestions(Boolean includeQuerySpellCheckSuggestions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean includeQuerySpellCheckSuggestions;

        private BuilderImpl() {
        }

        private BuilderImpl(SpellCorrectionConfiguration model) {
            includeQuerySpellCheckSuggestions(model.includeQuerySpellCheckSuggestions);
        }

        public final Boolean getIncludeQuerySpellCheckSuggestions() {
            return includeQuerySpellCheckSuggestions;
        }

        public final void setIncludeQuerySpellCheckSuggestions(Boolean includeQuerySpellCheckSuggestions) {
            this.includeQuerySpellCheckSuggestions = includeQuerySpellCheckSuggestions;
        }

        @Override
        public final Builder includeQuerySpellCheckSuggestions(Boolean includeQuerySpellCheckSuggestions) {
            this.includeQuerySpellCheckSuggestions = includeQuerySpellCheckSuggestions;
            return this;
        }

        @Override
        public SpellCorrectionConfiguration build() {
            return new SpellCorrectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
