/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how to group results by document attribute value, and how to display them collapsed/expanded under a
 * designated primary document for each group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollapseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CollapseConfiguration.Builder, CollapseConfiguration> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentAttributeKey").getter(getter(CollapseConfiguration::documentAttributeKey))
            .setter(setter(Builder::documentAttributeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build())
            .build();

    private static final SdkField<List<SortingConfiguration>> SORTING_CONFIGURATIONS_FIELD = SdkField
            .<List<SortingConfiguration>> builder(MarshallingType.LIST)
            .memberName("SortingConfigurations")
            .getter(getter(CollapseConfiguration::sortingConfigurations))
            .setter(setter(Builder::sortingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MISSING_ATTRIBUTE_KEY_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MissingAttributeKeyStrategy")
            .getter(getter(CollapseConfiguration::missingAttributeKeyStrategyAsString))
            .setter(setter(Builder::missingAttributeKeyStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingAttributeKeyStrategy")
                    .build()).build();

    private static final SdkField<Boolean> EXPAND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Expand").getter(getter(CollapseConfiguration::expand)).setter(setter(Builder::expand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expand").build()).build();

    private static final SdkField<ExpandConfiguration> EXPAND_CONFIGURATION_FIELD = SdkField
            .<ExpandConfiguration> builder(MarshallingType.SDK_POJO).memberName("ExpandConfiguration")
            .getter(getter(CollapseConfiguration::expandConfiguration)).setter(setter(Builder::expandConfiguration))
            .constructor(ExpandConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpandConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD,
            SORTING_CONFIGURATIONS_FIELD, MISSING_ATTRIBUTE_KEY_STRATEGY_FIELD, EXPAND_FIELD, EXPAND_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentAttributeKey;

    private final List<SortingConfiguration> sortingConfigurations;

    private final String missingAttributeKeyStrategy;

    private final Boolean expand;

    private final ExpandConfiguration expandConfiguration;

    private CollapseConfiguration(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.sortingConfigurations = builder.sortingConfigurations;
        this.missingAttributeKeyStrategy = builder.missingAttributeKeyStrategy;
        this.expand = builder.expand;
        this.expandConfiguration = builder.expandConfiguration;
    }

    /**
     * <p>
     * The document attribute used to group search results. You can use any attribute that has the <code>Sortable</code>
     * flag set to true. You can also sort by any of the following built-in attributes:"_category","_created_at",
     * "_last_updated_at", "_version", "_view_count".
     * </p>
     * 
     * @return The document attribute used to group search results. You can use any attribute that has the
     *         <code>Sortable</code> flag set to true. You can also sort by any of the following built-in
     *         attributes:"_category","_created_at", "_last_updated_at", "_version", "_view_count".
     */
    public final String documentAttributeKey() {
        return documentAttributeKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortingConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSortingConfigurations() {
        return sortingConfigurations != null && !(sortingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A prioritized list of document attributes/fields that determine the primary document among those in a collapsed
     * group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortingConfigurations} method.
     * </p>
     * 
     * @return A prioritized list of document attributes/fields that determine the primary document among those in a
     *         collapsed group.
     */
    public final List<SortingConfiguration> sortingConfigurations() {
        return sortingConfigurations;
    }

    /**
     * <p>
     * Specifies the behavior for documents without a value for the collapse attribute.
     * </p>
     * <p>
     * Amazon Kendra offers three customization options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the default
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear in query
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #missingAttributeKeyStrategy} will return {@link MissingAttributeKeyStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #missingAttributeKeyStrategyAsString}.
     * </p>
     * 
     * @return Specifies the behavior for documents without a value for the collapse attribute.</p>
     *         <p>
     *         Amazon Kendra offers three customization options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the
     *         default configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear in
     *         query results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
     *         </p>
     *         </li>
     * @see MissingAttributeKeyStrategy
     */
    public final MissingAttributeKeyStrategy missingAttributeKeyStrategy() {
        return MissingAttributeKeyStrategy.fromValue(missingAttributeKeyStrategy);
    }

    /**
     * <p>
     * Specifies the behavior for documents without a value for the collapse attribute.
     * </p>
     * <p>
     * Amazon Kendra offers three customization options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the default
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear in query
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #missingAttributeKeyStrategy} will return {@link MissingAttributeKeyStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #missingAttributeKeyStrategyAsString}.
     * </p>
     * 
     * @return Specifies the behavior for documents without a value for the collapse attribute.</p>
     *         <p>
     *         Amazon Kendra offers three customization options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the
     *         default configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear in
     *         query results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
     *         </p>
     *         </li>
     * @see MissingAttributeKeyStrategy
     */
    public final String missingAttributeKeyStrategyAsString() {
        return missingAttributeKeyStrategy;
    }

    /**
     * <p>
     * Specifies whether to expand the collapsed results.
     * </p>
     * 
     * @return Specifies whether to expand the collapsed results.
     */
    public final Boolean expand() {
        return expand;
    }

    /**
     * <p>
     * Provides configuration information to customize expansion options for a collapsed group.
     * </p>
     * 
     * @return Provides configuration information to customize expansion options for a collapsed group.
     */
    public final ExpandConfiguration expandConfiguration() {
        return expandConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortingConfigurations() ? sortingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(missingAttributeKeyStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expand());
        hashCode = 31 * hashCode + Objects.hashCode(expandConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollapseConfiguration)) {
            return false;
        }
        CollapseConfiguration other = (CollapseConfiguration) obj;
        return Objects.equals(documentAttributeKey(), other.documentAttributeKey())
                && hasSortingConfigurations() == other.hasSortingConfigurations()
                && Objects.equals(sortingConfigurations(), other.sortingConfigurations())
                && Objects.equals(missingAttributeKeyStrategyAsString(), other.missingAttributeKeyStrategyAsString())
                && Objects.equals(expand(), other.expand()) && Objects.equals(expandConfiguration(), other.expandConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollapseConfiguration").add("DocumentAttributeKey", documentAttributeKey())
                .add("SortingConfigurations", hasSortingConfigurations() ? sortingConfigurations() : null)
                .add("MissingAttributeKeyStrategy", missingAttributeKeyStrategyAsString()).add("Expand", expand())
                .add("ExpandConfiguration", expandConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentAttributeKey":
            return Optional.ofNullable(clazz.cast(documentAttributeKey()));
        case "SortingConfigurations":
            return Optional.ofNullable(clazz.cast(sortingConfigurations()));
        case "MissingAttributeKeyStrategy":
            return Optional.ofNullable(clazz.cast(missingAttributeKeyStrategyAsString()));
        case "Expand":
            return Optional.ofNullable(clazz.cast(expand()));
        case "ExpandConfiguration":
            return Optional.ofNullable(clazz.cast(expandConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CollapseConfiguration, T> g) {
        return obj -> g.apply((CollapseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollapseConfiguration> {
        /**
         * <p>
         * The document attribute used to group search results. You can use any attribute that has the
         * <code>Sortable</code> flag set to true. You can also sort by any of the following built-in
         * attributes:"_category","_created_at", "_last_updated_at", "_version", "_view_count".
         * </p>
         * 
         * @param documentAttributeKey
         *        The document attribute used to group search results. You can use any attribute that has the
         *        <code>Sortable</code> flag set to true. You can also sort by any of the following built-in
         *        attributes:"_category","_created_at", "_last_updated_at", "_version", "_view_count".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeKey(String documentAttributeKey);

        /**
         * <p>
         * A prioritized list of document attributes/fields that determine the primary document among those in a
         * collapsed group.
         * </p>
         * 
         * @param sortingConfigurations
         *        A prioritized list of document attributes/fields that determine the primary document among those in a
         *        collapsed group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingConfigurations(Collection<SortingConfiguration> sortingConfigurations);

        /**
         * <p>
         * A prioritized list of document attributes/fields that determine the primary document among those in a
         * collapsed group.
         * </p>
         * 
         * @param sortingConfigurations
         *        A prioritized list of document attributes/fields that determine the primary document among those in a
         *        collapsed group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingConfigurations(SortingConfiguration... sortingConfigurations);

        /**
         * <p>
         * A prioritized list of document attributes/fields that determine the primary document among those in a
         * collapsed group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortingConfigurations(List<SortingConfiguration>)}.
         * 
         * @param sortingConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.SortingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortingConfigurations(java.util.Collection<SortingConfiguration>)
         */
        Builder sortingConfigurations(Consumer<SortingConfiguration.Builder>... sortingConfigurations);

        /**
         * <p>
         * Specifies the behavior for documents without a value for the collapse attribute.
         * </p>
         * <p>
         * Amazon Kendra offers three customization options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the default
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear in
         * query results.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
         * </p>
         * </li>
         * </ul>
         * 
         * @param missingAttributeKeyStrategy
         *        Specifies the behavior for documents without a value for the collapse attribute.</p>
         *        <p>
         *        Amazon Kendra offers three customization options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the
         *        default configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear
         *        in query results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
         *        </p>
         *        </li>
         * @see MissingAttributeKeyStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MissingAttributeKeyStrategy
         */
        Builder missingAttributeKeyStrategy(String missingAttributeKeyStrategy);

        /**
         * <p>
         * Specifies the behavior for documents without a value for the collapse attribute.
         * </p>
         * <p>
         * Amazon Kendra offers three customization options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the default
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear in
         * query results.
         * </p>
         * </li>
         * <li>
         * <p>
         * Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
         * </p>
         * </li>
         * </ul>
         * 
         * @param missingAttributeKeyStrategy
         *        Specifies the behavior for documents without a value for the collapse attribute.</p>
         *        <p>
         *        Amazon Kendra offers three customization options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the
         *        default configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear
         *        in query results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.
         *        </p>
         *        </li>
         * @see MissingAttributeKeyStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MissingAttributeKeyStrategy
         */
        Builder missingAttributeKeyStrategy(MissingAttributeKeyStrategy missingAttributeKeyStrategy);

        /**
         * <p>
         * Specifies whether to expand the collapsed results.
         * </p>
         * 
         * @param expand
         *        Specifies whether to expand the collapsed results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expand(Boolean expand);

        /**
         * <p>
         * Provides configuration information to customize expansion options for a collapsed group.
         * </p>
         * 
         * @param expandConfiguration
         *        Provides configuration information to customize expansion options for a collapsed group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expandConfiguration(ExpandConfiguration expandConfiguration);

        /**
         * <p>
         * Provides configuration information to customize expansion options for a collapsed group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpandConfiguration.Builder} avoiding the
         * need to create one manually via {@link ExpandConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpandConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #expandConfiguration(ExpandConfiguration)}.
         * 
         * @param expandConfiguration
         *        a consumer that will call methods on {@link ExpandConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expandConfiguration(ExpandConfiguration)
         */
        default Builder expandConfiguration(Consumer<ExpandConfiguration.Builder> expandConfiguration) {
            return expandConfiguration(ExpandConfiguration.builder().applyMutation(expandConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String documentAttributeKey;

        private List<SortingConfiguration> sortingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String missingAttributeKeyStrategy;

        private Boolean expand;

        private ExpandConfiguration expandConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CollapseConfiguration model) {
            documentAttributeKey(model.documentAttributeKey);
            sortingConfigurations(model.sortingConfigurations);
            missingAttributeKeyStrategy(model.missingAttributeKeyStrategy);
            expand(model.expand);
            expandConfiguration(model.expandConfiguration);
        }

        public final String getDocumentAttributeKey() {
            return documentAttributeKey;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final List<SortingConfiguration.Builder> getSortingConfigurations() {
            List<SortingConfiguration.Builder> result = SortingConfigurationListCopier.copyToBuilder(this.sortingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortingConfigurations(Collection<SortingConfiguration.BuilderImpl> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copyFromBuilder(sortingConfigurations);
        }

        @Override
        public final Builder sortingConfigurations(Collection<SortingConfiguration> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copy(sortingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(SortingConfiguration... sortingConfigurations) {
            sortingConfigurations(Arrays.asList(sortingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(Consumer<SortingConfiguration.Builder>... sortingConfigurations) {
            sortingConfigurations(Stream.of(sortingConfigurations)
                    .map(c -> SortingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMissingAttributeKeyStrategy() {
            return missingAttributeKeyStrategy;
        }

        public final void setMissingAttributeKeyStrategy(String missingAttributeKeyStrategy) {
            this.missingAttributeKeyStrategy = missingAttributeKeyStrategy;
        }

        @Override
        public final Builder missingAttributeKeyStrategy(String missingAttributeKeyStrategy) {
            this.missingAttributeKeyStrategy = missingAttributeKeyStrategy;
            return this;
        }

        @Override
        public final Builder missingAttributeKeyStrategy(MissingAttributeKeyStrategy missingAttributeKeyStrategy) {
            this.missingAttributeKeyStrategy(missingAttributeKeyStrategy == null ? null : missingAttributeKeyStrategy.toString());
            return this;
        }

        public final Boolean getExpand() {
            return expand;
        }

        public final void setExpand(Boolean expand) {
            this.expand = expand;
        }

        @Override
        public final Builder expand(Boolean expand) {
            this.expand = expand;
            return this;
        }

        public final ExpandConfiguration.Builder getExpandConfiguration() {
            return expandConfiguration != null ? expandConfiguration.toBuilder() : null;
        }

        public final void setExpandConfiguration(ExpandConfiguration.BuilderImpl expandConfiguration) {
            this.expandConfiguration = expandConfiguration != null ? expandConfiguration.build() : null;
        }

        @Override
        public final Builder expandConfiguration(ExpandConfiguration expandConfiguration) {
            this.expandConfiguration = expandConfiguration;
            return this;
        }

        @Override
        public CollapseConfiguration build() {
            return new CollapseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
