/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AdditionalResultAttributeListCopier {
    static List<AdditionalResultAttribute> copy(Collection<? extends AdditionalResultAttribute> additionalResultAttributeListParam) {
        List<AdditionalResultAttribute> list;
        if (additionalResultAttributeListParam == null || additionalResultAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AdditionalResultAttribute> modifiableList = new ArrayList<>();
            additionalResultAttributeListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AdditionalResultAttribute> copyFromBuilder(
            Collection<? extends AdditionalResultAttribute.Builder> additionalResultAttributeListParam) {
        List<AdditionalResultAttribute> list;
        if (additionalResultAttributeListParam == null || additionalResultAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AdditionalResultAttribute> modifiableList = new ArrayList<>();
            additionalResultAttributeListParam.forEach(entry -> {
                AdditionalResultAttribute member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AdditionalResultAttribute.Builder> copyToBuilder(
            Collection<? extends AdditionalResultAttribute> additionalResultAttributeListParam) {
        List<AdditionalResultAttribute.Builder> list;
        if (additionalResultAttributeListParam == null || additionalResultAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AdditionalResultAttribute.Builder> modifiableList = new ArrayList<>();
            additionalResultAttributeListParam.forEach(entry -> {
                AdditionalResultAttribute.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
