/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFeaturedResultsSetRequest extends KendraRequest implements
        ToCopyableBuilder<CreateFeaturedResultsSetRequest.Builder, CreateFeaturedResultsSetRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(CreateFeaturedResultsSetRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> FEATURED_RESULTS_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturedResultsSetName").getter(getter(CreateFeaturedResultsSetRequest::featuredResultsSetName))
            .setter(setter(Builder::featuredResultsSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFeaturedResultsSetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateFeaturedResultsSetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateFeaturedResultsSetRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> QUERY_TEXTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueryTexts")
            .getter(getter(CreateFeaturedResultsSetRequest::queryTexts))
            .setter(setter(Builder::queryTexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FeaturedDocument>> FEATURED_DOCUMENTS_FIELD = SdkField
            .<List<FeaturedDocument>> builder(MarshallingType.LIST)
            .memberName("FeaturedDocuments")
            .getter(getter(CreateFeaturedResultsSetRequest::featuredDocuments))
            .setter(setter(Builder::featuredDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeaturedDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeaturedDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFeaturedResultsSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            FEATURED_RESULTS_SET_NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, STATUS_FIELD, QUERY_TEXTS_FIELD,
            FEATURED_DOCUMENTS_FIELD, TAGS_FIELD));

    private final String indexId;

    private final String featuredResultsSetName;

    private final String description;

    private final String clientToken;

    private final String status;

    private final List<String> queryTexts;

    private final List<FeaturedDocument> featuredDocuments;

    private final List<Tag> tags;

    private CreateFeaturedResultsSetRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.featuredResultsSetName = builder.featuredResultsSetName;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.status = builder.status;
        this.queryTexts = builder.queryTexts;
        this.featuredDocuments = builder.featuredDocuments;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the index that you want to use for featuring results.
     * </p>
     * 
     * @return The identifier of the index that you want to use for featuring results.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * A name for the set of featured results.
     * </p>
     * 
     * @return A name for the set of featured results.
     */
    public final String featuredResultsSetName() {
        return featuredResultsSetName;
    }

    /**
     * <p>
     * A description for the set of featured results.
     * </p>
     * 
     * @return A description for the set of featured results.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create a set of featured results. Multiple calls to the
     * <code>CreateFeaturedResultsSet</code> API with the same client token will create only one featured results set.
     * </p>
     * 
     * @return A token that you provide to identify the request to create a set of featured results. Multiple calls to
     *         the <code>CreateFeaturedResultsSet</code> API with the same client token will create only one featured
     *         results set.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are
     * ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can
     * set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
     * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
     * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeaturedResultsSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
     *         results are ready for use. You can still configure your settings before setting the status to
     *         <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
     *         UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
     *         featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see FeaturedResultsSetStatus
     */
    public final FeaturedResultsSetStatus status() {
        return FeaturedResultsSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are
     * ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can
     * set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
     * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
     * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeaturedResultsSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
     *         results are ready for use. You can still configure your settings before setting the status to
     *         <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
     *         UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
     *         featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see FeaturedResultsSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryTexts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueryTexts() {
        return queryTexts != null && !(queryTexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of queries for featuring results. For more information on the list of queries, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryTexts} method.
     * </p>
     * 
     * @return A list of queries for featuring results. For more information on the list of queries, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     */
    public final List<String> queryTexts() {
        return queryTexts;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturedDocuments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeaturedDocuments() {
        return featuredDocuments != null && !(featuredDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of document IDs for the documents you want to feature at the top of the search results page. For more
     * information on the list of documents, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturedDocuments} method.
     * </p>
     * 
     * @return A list of document IDs for the documents you want to feature at the top of the search results page. For
     *         more information on the list of documents, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     */
    public final List<FeaturedDocument> featuredDocuments() {
        return featuredDocuments;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize the featured results set. You can also use tags to help
     * control access to the featured results set. Tag keys and values can consist of Unicode letters, digits, white
     * space, and any of the following symbols:_ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize the featured results set. You can also use tags to
     *         help control access to the featured results set. Tag keys and values can consist of Unicode letters,
     *         digits, white space, and any of the following symbols:_ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(featuredResultsSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryTexts() ? queryTexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeaturedDocuments() ? featuredDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeaturedResultsSetRequest)) {
            return false;
        }
        CreateFeaturedResultsSetRequest other = (CreateFeaturedResultsSetRequest) obj;
        return Objects.equals(indexId(), other.indexId())
                && Objects.equals(featuredResultsSetName(), other.featuredResultsSetName())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasQueryTexts() == other.hasQueryTexts()
                && Objects.equals(queryTexts(), other.queryTexts()) && hasFeaturedDocuments() == other.hasFeaturedDocuments()
                && Objects.equals(featuredDocuments(), other.featuredDocuments()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFeaturedResultsSetRequest").add("IndexId", indexId())
                .add("FeaturedResultsSetName", featuredResultsSetName()).add("Description", description())
                .add("ClientToken", clientToken()).add("Status", statusAsString())
                .add("QueryTexts", hasQueryTexts() ? queryTexts() : null)
                .add("FeaturedDocuments", hasFeaturedDocuments() ? featuredDocuments() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "FeaturedResultsSetName":
            return Optional.ofNullable(clazz.cast(featuredResultsSetName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "QueryTexts":
            return Optional.ofNullable(clazz.cast(queryTexts()));
        case "FeaturedDocuments":
            return Optional.ofNullable(clazz.cast(featuredDocuments()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFeaturedResultsSetRequest, T> g) {
        return obj -> g.apply((CreateFeaturedResultsSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFeaturedResultsSetRequest> {
        /**
         * <p>
         * The identifier of the index that you want to use for featuring results.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that you want to use for featuring results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * A name for the set of featured results.
         * </p>
         * 
         * @param featuredResultsSetName
         *        A name for the set of featured results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetName(String featuredResultsSetName);

        /**
         * <p>
         * A description for the set of featured results.
         * </p>
         * 
         * @param description
         *        A description for the set of featured results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A token that you provide to identify the request to create a set of featured results. Multiple calls to the
         * <code>CreateFeaturedResultsSet</code> API with the same client token will create only one featured results
         * set.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create a set of featured results. Multiple calls
         *        to the <code>CreateFeaturedResultsSet</code> API with the same client token will create only one
         *        featured results set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results
         * are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>.
         * You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
         * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
         * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
         *        results are ready for use. You can still configure your settings before setting the status to
         *        <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
         *        UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
         *        featured results set for each index, whether the status is <code>ACTIVE</code> or
         *        <code>INACTIVE</code>.
         * @see FeaturedResultsSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturedResultsSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results
         * are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>.
         * You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
         * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
         * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
         *        results are ready for use. You can still configure your settings before setting the status to
         *        <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
         *        UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
         *        featured results set for each index, whether the status is <code>ACTIVE</code> or
         *        <code>INACTIVE</code>.
         * @see FeaturedResultsSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturedResultsSetStatus
         */
        Builder status(FeaturedResultsSetStatus status);

        /**
         * <p>
         * A list of queries for featuring results. For more information on the list of queries, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param queryTexts
         *        A list of queries for featuring results. For more information on the list of queries, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTexts(Collection<String> queryTexts);

        /**
         * <p>
         * A list of queries for featuring results. For more information on the list of queries, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param queryTexts
         *        A list of queries for featuring results. For more information on the list of queries, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTexts(String... queryTexts);

        /**
         * <p>
         * A list of document IDs for the documents you want to feature at the top of the search results page. For more
         * information on the list of documents, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param featuredDocuments
         *        A list of document IDs for the documents you want to feature at the top of the search results page.
         *        For more information on the list of documents, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredDocuments(Collection<FeaturedDocument> featuredDocuments);

        /**
         * <p>
         * A list of document IDs for the documents you want to feature at the top of the search results page. For more
         * information on the list of documents, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param featuredDocuments
         *        A list of document IDs for the documents you want to feature at the top of the search results page.
         *        For more information on the list of documents, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredDocuments(FeaturedDocument... featuredDocuments);

        /**
         * <p>
         * A list of document IDs for the documents you want to feature at the top of the search results page. For more
         * information on the list of documents, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocument.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.FeaturedDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocument.Builder#build()} is called immediately
         * and its result is passed to {@link #featuredDocuments(List<FeaturedDocument>)}.
         * 
         * @param featuredDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FeaturedDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featuredDocuments(java.util.Collection<FeaturedDocument>)
         */
        Builder featuredDocuments(Consumer<FeaturedDocument.Builder>... featuredDocuments);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the featured results set. You can also use tags to help
         * control access to the featured results set. Tag keys and values can consist of Unicode letters, digits, white
         * space, and any of the following symbols:_ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the featured results set. You can also use tags
         *        to help control access to the featured results set. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols:_ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the featured results set. You can also use tags to help
         * control access to the featured results set. Tag keys and values can consist of Unicode letters, digits, white
         * space, and any of the following symbols:_ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the featured results set. You can also use tags
         *        to help control access to the featured results set. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols:_ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the featured results set. You can also use tags to help
         * control access to the featured results set. Tag keys and values can consist of Unicode letters, digits, white
         * space, and any of the following symbols:_ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.kendra.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.kendra.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String featuredResultsSetName;

        private String description;

        private String clientToken;

        private String status;

        private List<String> queryTexts = DefaultSdkAutoConstructList.getInstance();

        private List<FeaturedDocument> featuredDocuments = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFeaturedResultsSetRequest model) {
            super(model);
            indexId(model.indexId);
            featuredResultsSetName(model.featuredResultsSetName);
            description(model.description);
            clientToken(model.clientToken);
            status(model.status);
            queryTexts(model.queryTexts);
            featuredDocuments(model.featuredDocuments);
            tags(model.tags);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getFeaturedResultsSetName() {
            return featuredResultsSetName;
        }

        public final void setFeaturedResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
        }

        @Override
        public final Builder featuredResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeaturedResultsSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getQueryTexts() {
            if (queryTexts instanceof SdkAutoConstructList) {
                return null;
            }
            return queryTexts;
        }

        public final void setQueryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
        }

        @Override
        public final Builder queryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryTexts(String... queryTexts) {
            queryTexts(Arrays.asList(queryTexts));
            return this;
        }

        public final List<FeaturedDocument.Builder> getFeaturedDocuments() {
            List<FeaturedDocument.Builder> result = FeaturedDocumentListCopier.copyToBuilder(this.featuredDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedDocuments(Collection<FeaturedDocument.BuilderImpl> featuredDocuments) {
            this.featuredDocuments = FeaturedDocumentListCopier.copyFromBuilder(featuredDocuments);
        }

        @Override
        public final Builder featuredDocuments(Collection<FeaturedDocument> featuredDocuments) {
            this.featuredDocuments = FeaturedDocumentListCopier.copy(featuredDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocuments(FeaturedDocument... featuredDocuments) {
            featuredDocuments(Arrays.asList(featuredDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocuments(Consumer<FeaturedDocument.Builder>... featuredDocuments) {
            featuredDocuments(Stream.of(featuredDocuments).map(c -> FeaturedDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFeaturedResultsSetRequest build() {
            return new CreateFeaturedResultsSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
