/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse;

public class ListStagesIterable
implements SdkIterable<ListStagesResponse> {
    private final IvsRealTimeClient client;
    private final ListStagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStagesIterable(IvsRealTimeClient client, ListStagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStagesResponseFetcher();
    }

    public Iterator<ListStagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStagesResponseFetcher
    implements SyncPageFetcher<ListStagesResponse> {
        private ListStagesResponseFetcher() {
        }

        public boolean hasNextPage(ListStagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStagesResponse nextPage(ListStagesResponse previousPage) {
            if (previousPage == null) {
                return ListStagesIterable.this.client.listStages(ListStagesIterable.this.firstRequest);
            }
            return ListStagesIterable.this.client.listStages((ListStagesRequest)((Object)ListStagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

