/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivschat.IvschatAsyncClient;
import software.amazon.awssdk.services.ivschat.model.ListRoomsRequest;
import software.amazon.awssdk.services.ivschat.model.ListRoomsResponse;

public class ListRoomsPublisher
implements SdkPublisher<ListRoomsResponse> {
    private final IvschatAsyncClient client;
    private final ListRoomsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoomsPublisher(IvschatAsyncClient client, ListRoomsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoomsPublisher(IvschatAsyncClient client, ListRoomsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoomsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoomsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRoomsResponseFetcher
    implements AsyncPageFetcher<ListRoomsResponse> {
        private ListRoomsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoomsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoomsResponse> nextPage(ListRoomsResponse previousPage) {
            if (previousPage == null) {
                return ListRoomsPublisher.this.client.listRooms(ListRoomsPublisher.this.firstRequest);
            }
            return ListRoomsPublisher.this.client.listRooms((ListRoomsRequest)((Object)ListRoomsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

