/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ivschat.DefaultIvschatAsyncClient;
import software.amazon.awssdk.services.ivschat.DefaultIvschatBaseClientBuilder;
import software.amazon.awssdk.services.ivschat.IvschatAsyncClient;
import software.amazon.awssdk.services.ivschat.IvschatAsyncClientBuilder;
import software.amazon.awssdk.services.ivschat.IvschatServiceClientConfiguration;
import software.amazon.awssdk.services.ivschat.endpoints.IvschatEndpointProvider;

@SdkInternalApi
final class DefaultIvschatAsyncClientBuilder
extends DefaultIvschatBaseClientBuilder<IvschatAsyncClientBuilder, IvschatAsyncClient>
implements IvschatAsyncClientBuilder {
    DefaultIvschatAsyncClientBuilder() {
    }

    @Override
    public DefaultIvschatAsyncClientBuilder endpointProvider(IvschatEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IvschatAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIvschatAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IvschatServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIvschatAsyncClient client = new DefaultIvschatAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IvschatServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IvschatServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

