/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a configuration of thumbnails for recorded video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThumbnailConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThumbnailConfiguration.Builder, ThumbnailConfiguration> {
    private static final SdkField<String> RECORDING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingMode").getter(getter(ThumbnailConfiguration::recordingModeAsString))
            .setter(setter(Builder::recordingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingMode").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolution").getter(getter(ThumbnailConfiguration::resolutionAsString))
            .setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()).build();

    private static final SdkField<List<String>> STORAGE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("storage")
            .getter(getter(ThumbnailConfiguration::storageAsStrings))
            .setter(setter(Builder::storageWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TARGET_INTERVAL_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("targetIntervalSeconds").getter(getter(ThumbnailConfiguration::targetIntervalSeconds))
            .setter(setter(Builder::targetIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIntervalSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDING_MODE_FIELD,
            RESOLUTION_FIELD, STORAGE_FIELD, TARGET_INTERVAL_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recordingMode;

    private final String resolution;

    private final List<String> storage;

    private final Long targetIntervalSeconds;

    private ThumbnailConfiguration(BuilderImpl builder) {
        this.recordingMode = builder.recordingMode;
        this.resolution = builder.resolution;
        this.storage = builder.storage;
        this.targetIntervalSeconds = builder.targetIntervalSeconds;
    }

    /**
     * <p>
     * Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingMode}
     * will return {@link RecordingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordingModeAsString}.
     * </p>
     * 
     * @return Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * @see RecordingMode
     */
    public final RecordingMode recordingMode() {
        return RecordingMode.fromValue(recordingMode);
    }

    /**
     * <p>
     * Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingMode}
     * will return {@link RecordingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordingModeAsString}.
     * </p>
     * 
     * @return Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * @see RecordingMode
     */
    public final String recordingModeAsString() {
        return recordingMode;
    }

    /**
     * <p>
     * Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected resolution if
     * the corresponding rendition is available during the stream; otherwise, they are recorded at source resolution.
     * For more information about resolution values and their corresponding height and width dimensions, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>. Default:
     * Null (source resolution is returned).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link ThumbnailConfigurationResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resolutionAsString}.
     * </p>
     * 
     * @return Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected
     *         resolution if the corresponding rendition is available during the stream; otherwise, they are recorded at
     *         source resolution. For more information about resolution values and their corresponding height and width
     *         dimensions, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record
     *         to Amazon S3</a>. Default: Null (source resolution is returned).
     * @see ThumbnailConfigurationResolution
     */
    public final ThumbnailConfigurationResolution resolution() {
        return ThumbnailConfigurationResolution.fromValue(resolution);
    }

    /**
     * <p>
     * Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected resolution if
     * the corresponding rendition is available during the stream; otherwise, they are recorded at source resolution.
     * For more information about resolution values and their corresponding height and width dimensions, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>. Default:
     * Null (source resolution is returned).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link ThumbnailConfigurationResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resolutionAsString}.
     * </p>
     * 
     * @return Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected
     *         resolution if the corresponding rendition is available during the stream; otherwise, they are recorded at
     *         source resolution. For more information about resolution values and their corresponding height and width
     *         dimensions, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record
     *         to Amazon S3</a>. Default: Null (source resolution is returned).
     * @see ThumbnailConfigurationResolution
     */
    public final String resolutionAsString() {
        return resolution;
    }

    /**
     * <p>
     * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated thumbnails
     * in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest thumbnail in
     * media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
     * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>. Default:
     * <code>SEQUENTIAL</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorage} method.
     * </p>
     * 
     * @return Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
     *         thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
     *         thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
     *         <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
     *         Default: <code>SEQUENTIAL</code>.
     */
    public final List<ThumbnailConfigurationStorage> storage() {
        return ThumbnailConfigurationStorageListCopier.copyStringToEnum(storage);
    }

    /**
     * For responses, this returns true if the service returned a value for the Storage property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStorage() {
        return storage != null && !(storage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated thumbnails
     * in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest thumbnail in
     * media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
     * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>. Default:
     * <code>SEQUENTIAL</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorage} method.
     * </p>
     * 
     * @return Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
     *         thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
     *         thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
     *         <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
     *         Default: <code>SEQUENTIAL</code>.
     */
    public final List<String> storageAsStrings() {
        return storage;
    }

    /**
     * <p>
     * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
     * <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.
     * </p>
     * <p>
     * <b>Important:</b> For the <code>BASIC</code> channel type, setting a value for <code>targetIntervalSeconds</code>
     * does not guarantee that thumbnails are generated at the specified interval. For thumbnails to be generated at the
     * <code>targetIntervalSeconds</code> interval, the <code>IDR/Keyframe</code> value for the input video must be less
     * than the <code>targetIntervalSeconds</code> value. See <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming
     * Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in video-encoder
     * settings.
     * </p>
     * 
     * @return The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
     *         <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.</p>
     *         <p>
     *         <b>Important:</b> For the <code>BASIC</code> channel type, setting a value for
     *         <code>targetIntervalSeconds</code> does not guarantee that thumbnails are generated at the specified
     *         interval. For thumbnails to be generated at the <code>targetIntervalSeconds</code> interval, the
     *         <code>IDR/Keyframe</code> value for the input video must be less than the
     *         <code>targetIntervalSeconds</code> value. See <a
     *         href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming
     *         Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in
     *         video-encoder settings.
     */
    public final Long targetIntervalSeconds() {
        return targetIntervalSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorage() ? storageAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetIntervalSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailConfiguration)) {
            return false;
        }
        ThumbnailConfiguration other = (ThumbnailConfiguration) obj;
        return Objects.equals(recordingModeAsString(), other.recordingModeAsString())
                && Objects.equals(resolutionAsString(), other.resolutionAsString()) && hasStorage() == other.hasStorage()
                && Objects.equals(storageAsStrings(), other.storageAsStrings())
                && Objects.equals(targetIntervalSeconds(), other.targetIntervalSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThumbnailConfiguration").add("RecordingMode", recordingModeAsString())
                .add("Resolution", resolutionAsString()).add("Storage", hasStorage() ? storageAsStrings() : null)
                .add("TargetIntervalSeconds", targetIntervalSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordingMode":
            return Optional.ofNullable(clazz.cast(recordingModeAsString()));
        case "resolution":
            return Optional.ofNullable(clazz.cast(resolutionAsString()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storageAsStrings()));
        case "targetIntervalSeconds":
            return Optional.ofNullable(clazz.cast(targetIntervalSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThumbnailConfiguration, T> g) {
        return obj -> g.apply((ThumbnailConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThumbnailConfiguration> {
        /**
         * <p>
         * Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * </p>
         * 
         * @param recordingMode
         *        Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * @see RecordingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingMode
         */
        Builder recordingMode(String recordingMode);

        /**
         * <p>
         * Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * </p>
         * 
         * @param recordingMode
         *        Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * @see RecordingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingMode
         */
        Builder recordingMode(RecordingMode recordingMode);

        /**
         * <p>
         * Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected resolution
         * if the corresponding rendition is available during the stream; otherwise, they are recorded at source
         * resolution. For more information about resolution values and their corresponding height and width dimensions,
         * see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         * S3</a>. Default: Null (source resolution is returned).
         * </p>
         * 
         * @param resolution
         *        Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected
         *        resolution if the corresponding rendition is available during the stream; otherwise, they are recorded
         *        at source resolution. For more information about resolution values and their corresponding height and
         *        width dimensions, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         *        S3</a>. Default: Null (source resolution is returned).
         * @see ThumbnailConfigurationResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThumbnailConfigurationResolution
         */
        Builder resolution(String resolution);

        /**
         * <p>
         * Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected resolution
         * if the corresponding rendition is available during the stream; otherwise, they are recorded at source
         * resolution. For more information about resolution values and their corresponding height and width dimensions,
         * see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         * S3</a>. Default: Null (source resolution is returned).
         * </p>
         * 
         * @param resolution
         *        Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected
         *        resolution if the corresponding rendition is available during the stream; otherwise, they are recorded
         *        at source resolution. For more information about resolution values and their corresponding height and
         *        width dimensions, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon
         *        S3</a>. Default: Null (source resolution is returned).
         * @see ThumbnailConfigurationResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThumbnailConfigurationResolution
         */
        Builder resolution(ThumbnailConfigurationResolution resolution);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         * thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         *        thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageWithStrings(Collection<String> storage);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         * thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         *        thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageWithStrings(String... storage);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         * thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         *        thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(Collection<ThumbnailConfigurationStorage> storage);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         * thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest
         *        thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(ThumbnailConfigurationStorage... storage);

        /**
         * <p>
         * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
         * <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.
         * </p>
         * <p>
         * <b>Important:</b> For the <code>BASIC</code> channel type, setting a value for
         * <code>targetIntervalSeconds</code> does not guarantee that thumbnails are generated at the specified
         * interval. For thumbnails to be generated at the <code>targetIntervalSeconds</code> interval, the
         * <code>IDR/Keyframe</code> value for the input video must be less than the <code>targetIntervalSeconds</code>
         * value. See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS
         * Streaming Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in
         * video-encoder settings.
         * </p>
         * 
         * @param targetIntervalSeconds
         *        The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
         *        <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.</p>
         *        <p>
         *        <b>Important:</b> For the <code>BASIC</code> channel type, setting a value for
         *        <code>targetIntervalSeconds</code> does not guarantee that thumbnails are generated at the specified
         *        interval. For thumbnails to be generated at the <code>targetIntervalSeconds</code> interval, the
         *        <code>IDR/Keyframe</code> value for the input video must be less than the
         *        <code>targetIntervalSeconds</code> value. See <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming
         *        Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in
         *        video-encoder settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIntervalSeconds(Long targetIntervalSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String recordingMode;

        private String resolution;

        private List<String> storage = DefaultSdkAutoConstructList.getInstance();

        private Long targetIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ThumbnailConfiguration model) {
            recordingMode(model.recordingMode);
            resolution(model.resolution);
            storageWithStrings(model.storage);
            targetIntervalSeconds(model.targetIntervalSeconds);
        }

        public final String getRecordingMode() {
            return recordingMode;
        }

        public final void setRecordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
        }

        @Override
        public final Builder recordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        @Override
        public final Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode(recordingMode == null ? null : recordingMode.toString());
            return this;
        }

        public final String getResolution() {
            return resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(ThumbnailConfigurationResolution resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final Collection<String> getStorage() {
            if (storage instanceof SdkAutoConstructList) {
                return null;
            }
            return storage;
        }

        public final void setStorage(Collection<String> storage) {
            this.storage = ThumbnailConfigurationStorageListCopier.copy(storage);
        }

        @Override
        public final Builder storageWithStrings(Collection<String> storage) {
            this.storage = ThumbnailConfigurationStorageListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageWithStrings(String... storage) {
            storageWithStrings(Arrays.asList(storage));
            return this;
        }

        @Override
        public final Builder storage(Collection<ThumbnailConfigurationStorage> storage) {
            this.storage = ThumbnailConfigurationStorageListCopier.copyEnumToString(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ThumbnailConfigurationStorage... storage) {
            storage(Arrays.asList(storage));
            return this;
        }

        public final Long getTargetIntervalSeconds() {
            return targetIntervalSeconds;
        }

        public final void setTargetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
        }

        @Override
        public final Builder targetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
            return this;
        }

        @Override
        public ThumbnailConfiguration build() {
            return new ThumbnailConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
