/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * WCDMA.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WcdmaObj implements SdkPojo, Serializable, ToCopyableBuilder<WcdmaObj.Builder, WcdmaObj> {
    private static final SdkField<Integer> MCC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mcc")
            .getter(getter(WcdmaObj::mcc)).setter(setter(Builder::mcc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()).build();

    private static final SdkField<Integer> MNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mnc")
            .getter(getter(WcdmaObj::mnc)).setter(setter(Builder::mnc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()).build();

    private static final SdkField<Integer> LAC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Lac")
            .getter(getter(WcdmaObj::lac)).setter(setter(Builder::lac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lac").build()).build();

    private static final SdkField<Integer> UTRAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UtranCid").getter(getter(WcdmaObj::utranCid)).setter(setter(Builder::utranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtranCid").build()).build();

    private static final SdkField<WcdmaLocalId> WCDMA_LOCAL_ID_FIELD = SdkField.<WcdmaLocalId> builder(MarshallingType.SDK_POJO)
            .memberName("WcdmaLocalId").getter(getter(WcdmaObj::wcdmaLocalId)).setter(setter(Builder::wcdmaLocalId))
            .constructor(WcdmaLocalId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WcdmaLocalId").build()).build();

    private static final SdkField<Integer> RSCP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rscp")
            .getter(getter(WcdmaObj::rscp)).setter(setter(Builder::rscp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rscp").build()).build();

    private static final SdkField<Integer> PATH_LOSS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PathLoss").getter(getter(WcdmaObj::pathLoss)).setter(setter(Builder::pathLoss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathLoss").build()).build();

    private static final SdkField<List<WcdmaNmrObj>> WCDMA_NMR_FIELD = SdkField
            .<List<WcdmaNmrObj>> builder(MarshallingType.LIST)
            .memberName("WcdmaNmr")
            .getter(getter(WcdmaObj::wcdmaNmr))
            .setter(setter(Builder::wcdmaNmr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WcdmaNmr").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WcdmaNmrObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(WcdmaNmrObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_FIELD, MNC_FIELD,
            LAC_FIELD, UTRAN_CID_FIELD, WCDMA_LOCAL_ID_FIELD, RSCP_FIELD, PATH_LOSS_FIELD, WCDMA_NMR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer mcc;

    private final Integer mnc;

    private final Integer lac;

    private final Integer utranCid;

    private final WcdmaLocalId wcdmaLocalId;

    private final Integer rscp;

    private final Integer pathLoss;

    private final List<WcdmaNmrObj> wcdmaNmr;

    private WcdmaObj(BuilderImpl builder) {
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.lac = builder.lac;
        this.utranCid = builder.utranCid;
        this.wcdmaLocalId = builder.wcdmaLocalId;
        this.rscp = builder.rscp;
        this.pathLoss = builder.pathLoss;
        this.wcdmaNmr = builder.wcdmaNmr;
    }

    /**
     * <p>
     * Mobile Country Code.
     * </p>
     * 
     * @return Mobile Country Code.
     */
    public final Integer mcc() {
        return mcc;
    }

    /**
     * <p>
     * Mobile Network Code.
     * </p>
     * 
     * @return Mobile Network Code.
     */
    public final Integer mnc() {
        return mnc;
    }

    /**
     * <p>
     * Location Area Code.
     * </p>
     * 
     * @return Location Area Code.
     */
    public final Integer lac() {
        return lac;
    }

    /**
     * <p>
     * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
     * </p>
     * 
     * @return UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
     */
    public final Integer utranCid() {
        return utranCid;
    }

    /**
     * <p>
     * WCDMA local ID information.
     * </p>
     * 
     * @return WCDMA local ID information.
     */
    public final WcdmaLocalId wcdmaLocalId() {
        return wcdmaLocalId;
    }

    /**
     * <p>
     * Received Signal Code Power (signal power) (dBm).
     * </p>
     * 
     * @return Received Signal Code Power (signal power) (dBm).
     */
    public final Integer rscp() {
        return rscp;
    }

    /**
     * <p>
     * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
     * through space.
     * </p>
     * 
     * @return Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
     *         propagates through space.
     */
    public final Integer pathLoss() {
        return pathLoss;
    }

    /**
     * For responses, this returns true if the service returned a value for the WcdmaNmr property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWcdmaNmr() {
        return wcdmaNmr != null && !(wcdmaNmr instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * WCDMA object for network measurement reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWcdmaNmr} method.
     * </p>
     * 
     * @return WCDMA object for network measurement reports.
     */
    public final List<WcdmaNmrObj> wcdmaNmr() {
        return wcdmaNmr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mcc());
        hashCode = 31 * hashCode + Objects.hashCode(mnc());
        hashCode = 31 * hashCode + Objects.hashCode(lac());
        hashCode = 31 * hashCode + Objects.hashCode(utranCid());
        hashCode = 31 * hashCode + Objects.hashCode(wcdmaLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(rscp());
        hashCode = 31 * hashCode + Objects.hashCode(pathLoss());
        hashCode = 31 * hashCode + Objects.hashCode(hasWcdmaNmr() ? wcdmaNmr() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WcdmaObj)) {
            return false;
        }
        WcdmaObj other = (WcdmaObj) obj;
        return Objects.equals(mcc(), other.mcc()) && Objects.equals(mnc(), other.mnc()) && Objects.equals(lac(), other.lac())
                && Objects.equals(utranCid(), other.utranCid()) && Objects.equals(wcdmaLocalId(), other.wcdmaLocalId())
                && Objects.equals(rscp(), other.rscp()) && Objects.equals(pathLoss(), other.pathLoss())
                && hasWcdmaNmr() == other.hasWcdmaNmr() && Objects.equals(wcdmaNmr(), other.wcdmaNmr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WcdmaObj").add("Mcc", mcc()).add("Mnc", mnc()).add("Lac", lac()).add("UtranCid", utranCid())
                .add("WcdmaLocalId", wcdmaLocalId()).add("Rscp", rscp()).add("PathLoss", pathLoss())
                .add("WcdmaNmr", hasWcdmaNmr() ? wcdmaNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mcc":
            return Optional.ofNullable(clazz.cast(mcc()));
        case "Mnc":
            return Optional.ofNullable(clazz.cast(mnc()));
        case "Lac":
            return Optional.ofNullable(clazz.cast(lac()));
        case "UtranCid":
            return Optional.ofNullable(clazz.cast(utranCid()));
        case "WcdmaLocalId":
            return Optional.ofNullable(clazz.cast(wcdmaLocalId()));
        case "Rscp":
            return Optional.ofNullable(clazz.cast(rscp()));
        case "PathLoss":
            return Optional.ofNullable(clazz.cast(pathLoss()));
        case "WcdmaNmr":
            return Optional.ofNullable(clazz.cast(wcdmaNmr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WcdmaObj, T> g) {
        return obj -> g.apply((WcdmaObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WcdmaObj> {
        /**
         * <p>
         * Mobile Country Code.
         * </p>
         * 
         * @param mcc
         *        Mobile Country Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcc(Integer mcc);

        /**
         * <p>
         * Mobile Network Code.
         * </p>
         * 
         * @param mnc
         *        Mobile Network Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mnc(Integer mnc);

        /**
         * <p>
         * Location Area Code.
         * </p>
         * 
         * @param lac
         *        Location Area Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lac(Integer lac);

        /**
         * <p>
         * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
         * </p>
         * 
         * @param utranCid
         *        UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utranCid(Integer utranCid);

        /**
         * <p>
         * WCDMA local ID information.
         * </p>
         * 
         * @param wcdmaLocalId
         *        WCDMA local ID information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wcdmaLocalId(WcdmaLocalId wcdmaLocalId);

        /**
         * <p>
         * WCDMA local ID information.
         * </p>
         * This is a convenience method that creates an instance of the {@link WcdmaLocalId.Builder} avoiding the need
         * to create one manually via {@link WcdmaLocalId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WcdmaLocalId.Builder#build()} is called immediately and its
         * result is passed to {@link #wcdmaLocalId(WcdmaLocalId)}.
         * 
         * @param wcdmaLocalId
         *        a consumer that will call methods on {@link WcdmaLocalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wcdmaLocalId(WcdmaLocalId)
         */
        default Builder wcdmaLocalId(Consumer<WcdmaLocalId.Builder> wcdmaLocalId) {
            return wcdmaLocalId(WcdmaLocalId.builder().applyMutation(wcdmaLocalId).build());
        }

        /**
         * <p>
         * Received Signal Code Power (signal power) (dBm).
         * </p>
         * 
         * @param rscp
         *        Received Signal Code Power (signal power) (dBm).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rscp(Integer rscp);

        /**
         * <p>
         * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
         * through space.
         * </p>
         * 
         * @param pathLoss
         *        Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
         *        propagates through space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathLoss(Integer pathLoss);

        /**
         * <p>
         * WCDMA object for network measurement reports.
         * </p>
         * 
         * @param wcdmaNmr
         *        WCDMA object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wcdmaNmr(Collection<WcdmaNmrObj> wcdmaNmr);

        /**
         * <p>
         * WCDMA object for network measurement reports.
         * </p>
         * 
         * @param wcdmaNmr
         *        WCDMA object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wcdmaNmr(WcdmaNmrObj... wcdmaNmr);

        /**
         * <p>
         * WCDMA object for network measurement reports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj.Builder#build()} is called immediately
         * and its result is passed to {@link #wcdmaNmr(List<WcdmaNmrObj>)}.
         * 
         * @param wcdmaNmr
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wcdmaNmr(java.util.Collection<WcdmaNmrObj>)
         */
        Builder wcdmaNmr(Consumer<WcdmaNmrObj.Builder>... wcdmaNmr);
    }

    static final class BuilderImpl implements Builder {
        private Integer mcc;

        private Integer mnc;

        private Integer lac;

        private Integer utranCid;

        private WcdmaLocalId wcdmaLocalId;

        private Integer rscp;

        private Integer pathLoss;

        private List<WcdmaNmrObj> wcdmaNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WcdmaObj model) {
            mcc(model.mcc);
            mnc(model.mnc);
            lac(model.lac);
            utranCid(model.utranCid);
            wcdmaLocalId(model.wcdmaLocalId);
            rscp(model.rscp);
            pathLoss(model.pathLoss);
            wcdmaNmr(model.wcdmaNmr);
        }

        public final Integer getMcc() {
            return mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final Integer getLac() {
            return lac;
        }

        public final void setLac(Integer lac) {
            this.lac = lac;
        }

        @Override
        public final Builder lac(Integer lac) {
            this.lac = lac;
            return this;
        }

        public final Integer getUtranCid() {
            return utranCid;
        }

        public final void setUtranCid(Integer utranCid) {
            this.utranCid = utranCid;
        }

        @Override
        public final Builder utranCid(Integer utranCid) {
            this.utranCid = utranCid;
            return this;
        }

        public final WcdmaLocalId.Builder getWcdmaLocalId() {
            return wcdmaLocalId != null ? wcdmaLocalId.toBuilder() : null;
        }

        public final void setWcdmaLocalId(WcdmaLocalId.BuilderImpl wcdmaLocalId) {
            this.wcdmaLocalId = wcdmaLocalId != null ? wcdmaLocalId.build() : null;
        }

        @Override
        public final Builder wcdmaLocalId(WcdmaLocalId wcdmaLocalId) {
            this.wcdmaLocalId = wcdmaLocalId;
            return this;
        }

        public final Integer getRscp() {
            return rscp;
        }

        public final void setRscp(Integer rscp) {
            this.rscp = rscp;
        }

        @Override
        public final Builder rscp(Integer rscp) {
            this.rscp = rscp;
            return this;
        }

        public final Integer getPathLoss() {
            return pathLoss;
        }

        public final void setPathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
        }

        @Override
        public final Builder pathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
            return this;
        }

        public final List<WcdmaNmrObj.Builder> getWcdmaNmr() {
            List<WcdmaNmrObj.Builder> result = WcdmaNmrListCopier.copyToBuilder(this.wcdmaNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWcdmaNmr(Collection<WcdmaNmrObj.BuilderImpl> wcdmaNmr) {
            this.wcdmaNmr = WcdmaNmrListCopier.copyFromBuilder(wcdmaNmr);
        }

        @Override
        public final Builder wcdmaNmr(Collection<WcdmaNmrObj> wcdmaNmr) {
            this.wcdmaNmr = WcdmaNmrListCopier.copy(wcdmaNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdmaNmr(WcdmaNmrObj... wcdmaNmr) {
            wcdmaNmr(Arrays.asList(wcdmaNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdmaNmr(Consumer<WcdmaNmrObj.Builder>... wcdmaNmr) {
            wcdmaNmr(Stream.of(wcdmaNmr).map(c -> WcdmaNmrObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WcdmaObj build() {
            return new WcdmaObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
