/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * GSM object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GsmObj implements SdkPojo, Serializable, ToCopyableBuilder<GsmObj.Builder, GsmObj> {
    private static final SdkField<Integer> MCC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mcc")
            .getter(getter(GsmObj::mcc)).setter(setter(Builder::mcc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()).build();

    private static final SdkField<Integer> MNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mnc")
            .getter(getter(GsmObj::mnc)).setter(setter(Builder::mnc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()).build();

    private static final SdkField<Integer> LAC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Lac")
            .getter(getter(GsmObj::lac)).setter(setter(Builder::lac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lac").build()).build();

    private static final SdkField<Integer> GERAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GeranCid").getter(getter(GsmObj::geranCid)).setter(setter(Builder::geranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeranCid").build()).build();

    private static final SdkField<GsmLocalId> GSM_LOCAL_ID_FIELD = SdkField.<GsmLocalId> builder(MarshallingType.SDK_POJO)
            .memberName("GsmLocalId").getter(getter(GsmObj::gsmLocalId)).setter(setter(Builder::gsmLocalId))
            .constructor(GsmLocalId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GsmLocalId").build()).build();

    private static final SdkField<Integer> GSM_TIMING_ADVANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GsmTimingAdvance").getter(getter(GsmObj::gsmTimingAdvance)).setter(setter(Builder::gsmTimingAdvance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GsmTimingAdvance").build()).build();

    private static final SdkField<Integer> RX_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RxLevel").getter(getter(GsmObj::rxLevel)).setter(setter(Builder::rxLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxLevel").build()).build();

    private static final SdkField<List<GsmNmrObj>> GSM_NMR_FIELD = SdkField
            .<List<GsmNmrObj>> builder(MarshallingType.LIST)
            .memberName("GsmNmr")
            .getter(getter(GsmObj::gsmNmr))
            .setter(setter(Builder::gsmNmr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GsmNmr").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GsmNmrObj> builder(MarshallingType.SDK_POJO)
                                            .constructor(GsmNmrObj::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_FIELD, MNC_FIELD,
            LAC_FIELD, GERAN_CID_FIELD, GSM_LOCAL_ID_FIELD, GSM_TIMING_ADVANCE_FIELD, RX_LEVEL_FIELD, GSM_NMR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer mcc;

    private final Integer mnc;

    private final Integer lac;

    private final Integer geranCid;

    private final GsmLocalId gsmLocalId;

    private final Integer gsmTimingAdvance;

    private final Integer rxLevel;

    private final List<GsmNmrObj> gsmNmr;

    private GsmObj(BuilderImpl builder) {
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.lac = builder.lac;
        this.geranCid = builder.geranCid;
        this.gsmLocalId = builder.gsmLocalId;
        this.gsmTimingAdvance = builder.gsmTimingAdvance;
        this.rxLevel = builder.rxLevel;
        this.gsmNmr = builder.gsmNmr;
    }

    /**
     * <p>
     * Mobile Country Code.
     * </p>
     * 
     * @return Mobile Country Code.
     */
    public final Integer mcc() {
        return mcc;
    }

    /**
     * <p>
     * Mobile Network Code.
     * </p>
     * 
     * @return Mobile Network Code.
     */
    public final Integer mnc() {
        return mnc;
    }

    /**
     * <p>
     * Location area code.
     * </p>
     * 
     * @return Location area code.
     */
    public final Integer lac() {
        return lac;
    }

    /**
     * <p>
     * GERAN (GSM EDGE Radio Access Network) Cell Global Identifier.
     * </p>
     * 
     * @return GERAN (GSM EDGE Radio Access Network) Cell Global Identifier.
     */
    public final Integer geranCid() {
        return geranCid;
    }

    /**
     * <p>
     * GSM local identification (local ID) information.
     * </p>
     * 
     * @return GSM local identification (local ID) information.
     */
    public final GsmLocalId gsmLocalId() {
        return gsmLocalId;
    }

    /**
     * <p>
     * Timing advance value, which corresponds to the length of time a signal takes to reach the base station from a
     * mobile phone.
     * </p>
     * 
     * @return Timing advance value, which corresponds to the length of time a signal takes to reach the base station
     *         from a mobile phone.
     */
    public final Integer gsmTimingAdvance() {
        return gsmTimingAdvance;
    }

    /**
     * <p>
     * Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
     * </p>
     * 
     * @return Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
     */
    public final Integer rxLevel() {
        return rxLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the GsmNmr property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGsmNmr() {
        return gsmNmr != null && !(gsmNmr instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * GSM object for network measurement reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGsmNmr} method.
     * </p>
     * 
     * @return GSM object for network measurement reports.
     */
    public final List<GsmNmrObj> gsmNmr() {
        return gsmNmr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mcc());
        hashCode = 31 * hashCode + Objects.hashCode(mnc());
        hashCode = 31 * hashCode + Objects.hashCode(lac());
        hashCode = 31 * hashCode + Objects.hashCode(geranCid());
        hashCode = 31 * hashCode + Objects.hashCode(gsmLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(gsmTimingAdvance());
        hashCode = 31 * hashCode + Objects.hashCode(rxLevel());
        hashCode = 31 * hashCode + Objects.hashCode(hasGsmNmr() ? gsmNmr() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GsmObj)) {
            return false;
        }
        GsmObj other = (GsmObj) obj;
        return Objects.equals(mcc(), other.mcc()) && Objects.equals(mnc(), other.mnc()) && Objects.equals(lac(), other.lac())
                && Objects.equals(geranCid(), other.geranCid()) && Objects.equals(gsmLocalId(), other.gsmLocalId())
                && Objects.equals(gsmTimingAdvance(), other.gsmTimingAdvance()) && Objects.equals(rxLevel(), other.rxLevel())
                && hasGsmNmr() == other.hasGsmNmr() && Objects.equals(gsmNmr(), other.gsmNmr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GsmObj").add("Mcc", mcc()).add("Mnc", mnc()).add("Lac", lac()).add("GeranCid", geranCid())
                .add("GsmLocalId", gsmLocalId()).add("GsmTimingAdvance", gsmTimingAdvance()).add("RxLevel", rxLevel())
                .add("GsmNmr", hasGsmNmr() ? gsmNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mcc":
            return Optional.ofNullable(clazz.cast(mcc()));
        case "Mnc":
            return Optional.ofNullable(clazz.cast(mnc()));
        case "Lac":
            return Optional.ofNullable(clazz.cast(lac()));
        case "GeranCid":
            return Optional.ofNullable(clazz.cast(geranCid()));
        case "GsmLocalId":
            return Optional.ofNullable(clazz.cast(gsmLocalId()));
        case "GsmTimingAdvance":
            return Optional.ofNullable(clazz.cast(gsmTimingAdvance()));
        case "RxLevel":
            return Optional.ofNullable(clazz.cast(rxLevel()));
        case "GsmNmr":
            return Optional.ofNullable(clazz.cast(gsmNmr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GsmObj, T> g) {
        return obj -> g.apply((GsmObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GsmObj> {
        /**
         * <p>
         * Mobile Country Code.
         * </p>
         * 
         * @param mcc
         *        Mobile Country Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcc(Integer mcc);

        /**
         * <p>
         * Mobile Network Code.
         * </p>
         * 
         * @param mnc
         *        Mobile Network Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mnc(Integer mnc);

        /**
         * <p>
         * Location area code.
         * </p>
         * 
         * @param lac
         *        Location area code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lac(Integer lac);

        /**
         * <p>
         * GERAN (GSM EDGE Radio Access Network) Cell Global Identifier.
         * </p>
         * 
         * @param geranCid
         *        GERAN (GSM EDGE Radio Access Network) Cell Global Identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geranCid(Integer geranCid);

        /**
         * <p>
         * GSM local identification (local ID) information.
         * </p>
         * 
         * @param gsmLocalId
         *        GSM local identification (local ID) information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gsmLocalId(GsmLocalId gsmLocalId);

        /**
         * <p>
         * GSM local identification (local ID) information.
         * </p>
         * This is a convenience method that creates an instance of the {@link GsmLocalId.Builder} avoiding the need to
         * create one manually via {@link GsmLocalId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GsmLocalId.Builder#build()} is called immediately and its result
         * is passed to {@link #gsmLocalId(GsmLocalId)}.
         * 
         * @param gsmLocalId
         *        a consumer that will call methods on {@link GsmLocalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gsmLocalId(GsmLocalId)
         */
        default Builder gsmLocalId(Consumer<GsmLocalId.Builder> gsmLocalId) {
            return gsmLocalId(GsmLocalId.builder().applyMutation(gsmLocalId).build());
        }

        /**
         * <p>
         * Timing advance value, which corresponds to the length of time a signal takes to reach the base station from a
         * mobile phone.
         * </p>
         * 
         * @param gsmTimingAdvance
         *        Timing advance value, which corresponds to the length of time a signal takes to reach the base station
         *        from a mobile phone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gsmTimingAdvance(Integer gsmTimingAdvance);

        /**
         * <p>
         * Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
         * </p>
         * 
         * @param rxLevel
         *        Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxLevel(Integer rxLevel);

        /**
         * <p>
         * GSM object for network measurement reports.
         * </p>
         * 
         * @param gsmNmr
         *        GSM object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gsmNmr(Collection<GsmNmrObj> gsmNmr);

        /**
         * <p>
         * GSM object for network measurement reports.
         * </p>
         * 
         * @param gsmNmr
         *        GSM object for network measurement reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gsmNmr(GsmNmrObj... gsmNmr);

        /**
         * <p>
         * GSM object for network measurement reports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.GsmNmrObj.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.GsmNmrObj#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.GsmNmrObj.Builder#build()} is called immediately and
         * its result is passed to {@link #gsmNmr(List<GsmNmrObj>)}.
         * 
         * @param gsmNmr
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.GsmNmrObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gsmNmr(java.util.Collection<GsmNmrObj>)
         */
        Builder gsmNmr(Consumer<GsmNmrObj.Builder>... gsmNmr);
    }

    static final class BuilderImpl implements Builder {
        private Integer mcc;

        private Integer mnc;

        private Integer lac;

        private Integer geranCid;

        private GsmLocalId gsmLocalId;

        private Integer gsmTimingAdvance;

        private Integer rxLevel;

        private List<GsmNmrObj> gsmNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GsmObj model) {
            mcc(model.mcc);
            mnc(model.mnc);
            lac(model.lac);
            geranCid(model.geranCid);
            gsmLocalId(model.gsmLocalId);
            gsmTimingAdvance(model.gsmTimingAdvance);
            rxLevel(model.rxLevel);
            gsmNmr(model.gsmNmr);
        }

        public final Integer getMcc() {
            return mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final Integer getLac() {
            return lac;
        }

        public final void setLac(Integer lac) {
            this.lac = lac;
        }

        @Override
        public final Builder lac(Integer lac) {
            this.lac = lac;
            return this;
        }

        public final Integer getGeranCid() {
            return geranCid;
        }

        public final void setGeranCid(Integer geranCid) {
            this.geranCid = geranCid;
        }

        @Override
        public final Builder geranCid(Integer geranCid) {
            this.geranCid = geranCid;
            return this;
        }

        public final GsmLocalId.Builder getGsmLocalId() {
            return gsmLocalId != null ? gsmLocalId.toBuilder() : null;
        }

        public final void setGsmLocalId(GsmLocalId.BuilderImpl gsmLocalId) {
            this.gsmLocalId = gsmLocalId != null ? gsmLocalId.build() : null;
        }

        @Override
        public final Builder gsmLocalId(GsmLocalId gsmLocalId) {
            this.gsmLocalId = gsmLocalId;
            return this;
        }

        public final Integer getGsmTimingAdvance() {
            return gsmTimingAdvance;
        }

        public final void setGsmTimingAdvance(Integer gsmTimingAdvance) {
            this.gsmTimingAdvance = gsmTimingAdvance;
        }

        @Override
        public final Builder gsmTimingAdvance(Integer gsmTimingAdvance) {
            this.gsmTimingAdvance = gsmTimingAdvance;
            return this;
        }

        public final Integer getRxLevel() {
            return rxLevel;
        }

        public final void setRxLevel(Integer rxLevel) {
            this.rxLevel = rxLevel;
        }

        @Override
        public final Builder rxLevel(Integer rxLevel) {
            this.rxLevel = rxLevel;
            return this;
        }

        public final List<GsmNmrObj.Builder> getGsmNmr() {
            List<GsmNmrObj.Builder> result = GsmNmrListCopier.copyToBuilder(this.gsmNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGsmNmr(Collection<GsmNmrObj.BuilderImpl> gsmNmr) {
            this.gsmNmr = GsmNmrListCopier.copyFromBuilder(gsmNmr);
        }

        @Override
        public final Builder gsmNmr(Collection<GsmNmrObj> gsmNmr) {
            this.gsmNmr = GsmNmrListCopier.copy(gsmNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsmNmr(GsmNmrObj... gsmNmr) {
            gsmNmr(Arrays.asList(gsmNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsmNmr(Consumer<GsmNmrObj.Builder>... gsmNmr) {
            gsmNmr(Stream.of(gsmNmr).map(c -> GsmNmrObj.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GsmObj build() {
            return new GsmObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
