/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The LoRaWAN information used with the multicast session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANMulticastSession implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANMulticastSession.Builder, LoRaWANMulticastSession> {
    private static final SdkField<Integer> DL_DR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("DlDr")
            .getter(getter(LoRaWANMulticastSession::dlDr)).setter(setter(Builder::dlDr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlDr").build()).build();

    private static final SdkField<Integer> DL_FREQ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DlFreq").getter(getter(LoRaWANMulticastSession::dlFreq)).setter(setter(Builder::dlFreq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlFreq").build()).build();

    private static final SdkField<Instant> SESSION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SessionStartTime")
            .getter(getter(LoRaWANMulticastSession::sessionStartTime))
            .setter(setter(Builder::sessionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionTimeout").getter(getter(LoRaWANMulticastSession::sessionTimeout))
            .setter(setter(Builder::sessionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeout").build()).build();

    private static final SdkField<Integer> PING_SLOT_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PingSlotPeriod").getter(getter(LoRaWANMulticastSession::pingSlotPeriod))
            .setter(setter(Builder::pingSlotPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DL_DR_FIELD, DL_FREQ_FIELD,
            SESSION_START_TIME_FIELD, SESSION_TIMEOUT_FIELD, PING_SLOT_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dlDr;

    private final Integer dlFreq;

    private final Instant sessionStartTime;

    private final Integer sessionTimeout;

    private final Integer pingSlotPeriod;

    private LoRaWANMulticastSession(BuilderImpl builder) {
        this.dlDr = builder.dlDr;
        this.dlFreq = builder.dlFreq;
        this.sessionStartTime = builder.sessionStartTime;
        this.sessionTimeout = builder.sessionTimeout;
        this.pingSlotPeriod = builder.pingSlotPeriod;
    }

    /**
     * Returns the value of the DlDr property for this object.
     * 
     * @return The value of the DlDr property for this object.
     */
    public final Integer dlDr() {
        return dlDr;
    }

    /**
     * Returns the value of the DlFreq property for this object.
     * 
     * @return The value of the DlFreq property for this object.
     */
    public final Integer dlFreq() {
        return dlFreq;
    }

    /**
     * Returns the value of the SessionStartTime property for this object.
     * 
     * @return The value of the SessionStartTime property for this object.
     */
    public final Instant sessionStartTime() {
        return sessionStartTime;
    }

    /**
     * Returns the value of the SessionTimeout property for this object.
     * 
     * @return The value of the SessionTimeout property for this object.
     */
    public final Integer sessionTimeout() {
        return sessionTimeout;
    }

    /**
     * <p>
     * The PingSlotPeriod value.
     * </p>
     * 
     * @return The PingSlotPeriod value.
     */
    public final Integer pingSlotPeriod() {
        return pingSlotPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dlDr());
        hashCode = 31 * hashCode + Objects.hashCode(dlFreq());
        hashCode = 31 * hashCode + Objects.hashCode(sessionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(pingSlotPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANMulticastSession)) {
            return false;
        }
        LoRaWANMulticastSession other = (LoRaWANMulticastSession) obj;
        return Objects.equals(dlDr(), other.dlDr()) && Objects.equals(dlFreq(), other.dlFreq())
                && Objects.equals(sessionStartTime(), other.sessionStartTime())
                && Objects.equals(sessionTimeout(), other.sessionTimeout())
                && Objects.equals(pingSlotPeriod(), other.pingSlotPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANMulticastSession").add("DlDr", dlDr()).add("DlFreq", dlFreq())
                .add("SessionStartTime", sessionStartTime()).add("SessionTimeout", sessionTimeout())
                .add("PingSlotPeriod", pingSlotPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DlDr":
            return Optional.ofNullable(clazz.cast(dlDr()));
        case "DlFreq":
            return Optional.ofNullable(clazz.cast(dlFreq()));
        case "SessionStartTime":
            return Optional.ofNullable(clazz.cast(sessionStartTime()));
        case "SessionTimeout":
            return Optional.ofNullable(clazz.cast(sessionTimeout()));
        case "PingSlotPeriod":
            return Optional.ofNullable(clazz.cast(pingSlotPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANMulticastSession, T> g) {
        return obj -> g.apply((LoRaWANMulticastSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANMulticastSession> {
        /**
         * Sets the value of the DlDr property for this object.
         *
         * @param dlDr
         *        The new value for the DlDr property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlDr(Integer dlDr);

        /**
         * Sets the value of the DlFreq property for this object.
         *
         * @param dlFreq
         *        The new value for the DlFreq property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlFreq(Integer dlFreq);

        /**
         * Sets the value of the SessionStartTime property for this object.
         *
         * @param sessionStartTime
         *        The new value for the SessionStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionStartTime(Instant sessionStartTime);

        /**
         * Sets the value of the SessionTimeout property for this object.
         *
         * @param sessionTimeout
         *        The new value for the SessionTimeout property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeout(Integer sessionTimeout);

        /**
         * <p>
         * The PingSlotPeriod value.
         * </p>
         * 
         * @param pingSlotPeriod
         *        The PingSlotPeriod value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pingSlotPeriod(Integer pingSlotPeriod);
    }

    static final class BuilderImpl implements Builder {
        private Integer dlDr;

        private Integer dlFreq;

        private Instant sessionStartTime;

        private Integer sessionTimeout;

        private Integer pingSlotPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANMulticastSession model) {
            dlDr(model.dlDr);
            dlFreq(model.dlFreq);
            sessionStartTime(model.sessionStartTime);
            sessionTimeout(model.sessionTimeout);
            pingSlotPeriod(model.pingSlotPeriod);
        }

        public final Integer getDlDr() {
            return dlDr;
        }

        public final void setDlDr(Integer dlDr) {
            this.dlDr = dlDr;
        }

        @Override
        public final Builder dlDr(Integer dlDr) {
            this.dlDr = dlDr;
            return this;
        }

        public final Integer getDlFreq() {
            return dlFreq;
        }

        public final void setDlFreq(Integer dlFreq) {
            this.dlFreq = dlFreq;
        }

        @Override
        public final Builder dlFreq(Integer dlFreq) {
            this.dlFreq = dlFreq;
            return this;
        }

        public final Instant getSessionStartTime() {
            return sessionStartTime;
        }

        public final void setSessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
        }

        @Override
        public final Builder sessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        public final Integer getSessionTimeout() {
            return sessionTimeout;
        }

        public final void setSessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final Integer getPingSlotPeriod() {
            return pingSlotPeriod;
        }

        public final void setPingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
        }

        @Override
        public final Builder pingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
            return this;
        }

        @Override
        public LoRaWANMulticastSession build() {
            return new LoRaWANMulticastSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
