/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse;

public class ListWirelessGatewaysPublisher
implements SdkPublisher<ListWirelessGatewaysResponse> {
    private final IotWirelessAsyncClient client;
    private final ListWirelessGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWirelessGatewaysPublisher(IotWirelessAsyncClient client, ListWirelessGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWirelessGatewaysPublisher(IotWirelessAsyncClient client, ListWirelessGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWirelessGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWirelessGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWirelessGatewaysResponseFetcher
    implements AsyncPageFetcher<ListWirelessGatewaysResponse> {
        private ListWirelessGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListWirelessGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWirelessGatewaysResponse> nextPage(ListWirelessGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListWirelessGatewaysPublisher.this.client.listWirelessGateways(ListWirelessGatewaysPublisher.this.firstRequest);
            }
            return ListWirelessGatewaysPublisher.this.client.listWirelessGateways((ListWirelessGatewaysRequest)((Object)ListWirelessGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

