/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.ServiceProfile;
import software.amazon.awssdk.services.iotwireless.model.ServiceProfileListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceProfilesResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListServiceProfilesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceProfilesResponse.getter(ListServiceProfilesResponse::nextToken)).setter(ListServiceProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ServiceProfile>> SERVICE_PROFILE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceProfileList").getter(ListServiceProfilesResponse.getter(ListServiceProfilesResponse::serviceProfileList)).setter(ListServiceProfilesResponse.setter(Builder::serviceProfileList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProfileList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICE_PROFILE_LIST_FIELD));
    private final String nextToken;
    private final List<ServiceProfile> serviceProfileList;

    private ListServiceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceProfileList = builder.serviceProfileList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServiceProfileList() {
        return this.serviceProfileList != null && !(this.serviceProfileList instanceof SdkAutoConstructList);
    }

    public final List<ServiceProfile> serviceProfileList() {
        return this.serviceProfileList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceProfileList() ? this.serviceProfileList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceProfilesResponse)) {
            return false;
        }
        ListServiceProfilesResponse other = (ListServiceProfilesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServiceProfileList() == other.hasServiceProfileList() && Objects.equals(this.serviceProfileList(), other.serviceProfileList());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceProfilesResponse").add("NextToken", (Object)this.nextToken()).add("ServiceProfileList", this.hasServiceProfileList() ? this.serviceProfileList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServiceProfileList": {
                return Optional.ofNullable(clazz.cast(this.serviceProfileList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceProfilesResponse, T> g) {
        return obj -> g.apply((ListServiceProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceProfile> serviceProfileList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceProfilesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serviceProfileList(model.serviceProfileList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceProfile.Builder> getServiceProfileList() {
            List<ServiceProfile.Builder> result = ServiceProfileListCopier.copyToBuilder(this.serviceProfileList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceProfileList(Collection<ServiceProfile.BuilderImpl> serviceProfileList) {
            this.serviceProfileList = ServiceProfileListCopier.copyFromBuilder(serviceProfileList);
        }

        @Override
        public final Builder serviceProfileList(Collection<ServiceProfile> serviceProfileList) {
            this.serviceProfileList = ServiceProfileListCopier.copy(serviceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceProfileList(ServiceProfile ... serviceProfileList) {
            this.serviceProfileList(Arrays.asList(serviceProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceProfileList(Consumer<ServiceProfile.Builder> ... serviceProfileList) {
            this.serviceProfileList(Stream.of(serviceProfileList).map(c -> (ServiceProfile)((ServiceProfile.Builder)ServiceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServiceProfilesResponse build() {
            return new ListServiceProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceProfilesResponse> {
        public Builder nextToken(String var1);

        public Builder serviceProfileList(Collection<ServiceProfile> var1);

        public Builder serviceProfileList(ServiceProfile ... var1);

        public Builder serviceProfileList(Consumer<ServiceProfile.Builder> ... var1);
    }
}

