/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Sidewalk device that has been added to an import task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportedSidewalkDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportedSidewalkDevice.Builder, ImportedSidewalkDevice> {
    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SidewalkManufacturingSn").getter(getter(ImportedSidewalkDevice::sidewalkManufacturingSn))
            .setter(setter(Builder::sidewalkManufacturingSn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build())
            .build();

    private static final SdkField<String> ONBOARDING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnboardingStatus").getter(getter(ImportedSidewalkDevice::onboardingStatusAsString))
            .setter(setter(Builder::onboardingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnboardingStatus").build()).build();

    private static final SdkField<String> ONBOARDING_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnboardingStatusReason").getter(getter(ImportedSidewalkDevice::onboardingStatusReason))
            .setter(setter(Builder::onboardingStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnboardingStatusReason").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime")
            .getter(getter(ImportedSidewalkDevice::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIDEWALK_MANUFACTURING_SN_FIELD, ONBOARDING_STATUS_FIELD, ONBOARDING_STATUS_REASON_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sidewalkManufacturingSn;

    private final String onboardingStatus;

    private final String onboardingStatusReason;

    private final Instant lastUpdateTime;

    private ImportedSidewalkDevice(BuilderImpl builder) {
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
        this.onboardingStatus = builder.onboardingStatus;
        this.onboardingStatusReason = builder.onboardingStatusReason;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The Sidewalk manufacturing serial number (SMSN) of the Sidewalk device.
     * </p>
     * 
     * @return The Sidewalk manufacturing serial number (SMSN) of the Sidewalk device.
     */
    public final String sidewalkManufacturingSn() {
        return sidewalkManufacturingSn;
    }

    /**
     * <p>
     * The onboarding status of the Sidewalk device in the import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingStatus}
     * will return {@link OnboardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #onboardingStatusAsString}.
     * </p>
     * 
     * @return The onboarding status of the Sidewalk device in the import task.
     * @see OnboardStatus
     */
    public final OnboardStatus onboardingStatus() {
        return OnboardStatus.fromValue(onboardingStatus);
    }

    /**
     * <p>
     * The onboarding status of the Sidewalk device in the import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onboardingStatus}
     * will return {@link OnboardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #onboardingStatusAsString}.
     * </p>
     * 
     * @return The onboarding status of the Sidewalk device in the import task.
     * @see OnboardStatus
     */
    public final String onboardingStatusAsString() {
        return onboardingStatus;
    }

    /**
     * <p>
     * The reason for the onboarding status information for the Sidewalk device.
     * </p>
     * 
     * @return The reason for the onboarding status information for the Sidewalk device.
     */
    public final String onboardingStatusReason() {
        return onboardingStatusReason;
    }

    /**
     * <p>
     * The time at which the status information was last updated.
     * </p>
     * 
     * @return The time at which the status information was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sidewalkManufacturingSn());
        hashCode = 31 * hashCode + Objects.hashCode(onboardingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onboardingStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportedSidewalkDevice)) {
            return false;
        }
        ImportedSidewalkDevice other = (ImportedSidewalkDevice) obj;
        return Objects.equals(sidewalkManufacturingSn(), other.sidewalkManufacturingSn())
                && Objects.equals(onboardingStatusAsString(), other.onboardingStatusAsString())
                && Objects.equals(onboardingStatusReason(), other.onboardingStatusReason())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportedSidewalkDevice").add("SidewalkManufacturingSn", sidewalkManufacturingSn())
                .add("OnboardingStatus", onboardingStatusAsString()).add("OnboardingStatusReason", onboardingStatusReason())
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SidewalkManufacturingSn":
            return Optional.ofNullable(clazz.cast(sidewalkManufacturingSn()));
        case "OnboardingStatus":
            return Optional.ofNullable(clazz.cast(onboardingStatusAsString()));
        case "OnboardingStatusReason":
            return Optional.ofNullable(clazz.cast(onboardingStatusReason()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportedSidewalkDevice, T> g) {
        return obj -> g.apply((ImportedSidewalkDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportedSidewalkDevice> {
        /**
         * <p>
         * The Sidewalk manufacturing serial number (SMSN) of the Sidewalk device.
         * </p>
         * 
         * @param sidewalkManufacturingSn
         *        The Sidewalk manufacturing serial number (SMSN) of the Sidewalk device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalkManufacturingSn(String sidewalkManufacturingSn);

        /**
         * <p>
         * The onboarding status of the Sidewalk device in the import task.
         * </p>
         * 
         * @param onboardingStatus
         *        The onboarding status of the Sidewalk device in the import task.
         * @see OnboardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardStatus
         */
        Builder onboardingStatus(String onboardingStatus);

        /**
         * <p>
         * The onboarding status of the Sidewalk device in the import task.
         * </p>
         * 
         * @param onboardingStatus
         *        The onboarding status of the Sidewalk device in the import task.
         * @see OnboardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnboardStatus
         */
        Builder onboardingStatus(OnboardStatus onboardingStatus);

        /**
         * <p>
         * The reason for the onboarding status information for the Sidewalk device.
         * </p>
         * 
         * @param onboardingStatusReason
         *        The reason for the onboarding status information for the Sidewalk device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onboardingStatusReason(String onboardingStatusReason);

        /**
         * <p>
         * The time at which the status information was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time at which the status information was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String sidewalkManufacturingSn;

        private String onboardingStatus;

        private String onboardingStatusReason;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportedSidewalkDevice model) {
            sidewalkManufacturingSn(model.sidewalkManufacturingSn);
            onboardingStatus(model.onboardingStatus);
            onboardingStatusReason(model.onboardingStatusReason);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getSidewalkManufacturingSn() {
            return sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        public final String getOnboardingStatus() {
            return onboardingStatus;
        }

        public final void setOnboardingStatus(String onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
        }

        @Override
        public final Builder onboardingStatus(String onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
            return this;
        }

        @Override
        public final Builder onboardingStatus(OnboardStatus onboardingStatus) {
            this.onboardingStatus(onboardingStatus == null ? null : onboardingStatus.toString());
            return this;
        }

        public final String getOnboardingStatusReason() {
            return onboardingStatusReason;
        }

        public final void setOnboardingStatusReason(String onboardingStatusReason) {
            this.onboardingStatusReason = onboardingStatusReason;
        }

        @Override
        public final Builder onboardingStatusReason(String onboardingStatusReason) {
            this.onboardingStatusReason = onboardingStatusReason;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public ImportedSidewalkDevice build() {
            return new ImportedSidewalkDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
