/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterWirelessDeviceRequest extends IotWirelessRequest implements
        ToCopyableBuilder<DeregisterWirelessDeviceRequest.Builder, DeregisterWirelessDeviceRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(DeregisterWirelessDeviceRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> WIRELESS_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WirelessDeviceType").getter(getter(DeregisterWirelessDeviceRequest::wirelessDeviceTypeAsString))
            .setter(setter(Builder::wirelessDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("WirelessDeviceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            WIRELESS_DEVICE_TYPE_FIELD));

    private final String identifier;

    private final String wirelessDeviceType;

    private DeregisterWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.wirelessDeviceType = builder.wirelessDeviceType;
    }

    /**
     * <p>
     * The identifier of the wireless device to deregister from AWS IoT Wireless.
     * </p>
     * 
     * @return The identifier of the wireless device to deregister from AWS IoT Wireless.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
     * <code>Sidewalk</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceType} will return {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #wirelessDeviceTypeAsString}.
     * </p>
     * 
     * @return The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
     *         <code>Sidewalk</code>.
     * @see WirelessDeviceType
     */
    public final WirelessDeviceType wirelessDeviceType() {
        return WirelessDeviceType.fromValue(wirelessDeviceType);
    }

    /**
     * <p>
     * The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
     * <code>Sidewalk</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceType} will return {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #wirelessDeviceTypeAsString}.
     * </p>
     * 
     * @return The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
     *         <code>Sidewalk</code>.
     * @see WirelessDeviceType
     */
    public final String wirelessDeviceTypeAsString() {
        return wirelessDeviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(wirelessDeviceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterWirelessDeviceRequest)) {
            return false;
        }
        DeregisterWirelessDeviceRequest other = (DeregisterWirelessDeviceRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(wirelessDeviceTypeAsString(), other.wirelessDeviceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterWirelessDeviceRequest").add("Identifier", identifier())
                .add("WirelessDeviceType", wirelessDeviceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "WirelessDeviceType":
            return Optional.ofNullable(clazz.cast(wirelessDeviceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterWirelessDeviceRequest, T> g) {
        return obj -> g.apply((DeregisterWirelessDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterWirelessDeviceRequest> {
        /**
         * <p>
         * The identifier of the wireless device to deregister from AWS IoT Wireless.
         * </p>
         * 
         * @param identifier
         *        The identifier of the wireless device to deregister from AWS IoT Wireless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
         * <code>Sidewalk</code>.
         * </p>
         * 
         * @param wirelessDeviceType
         *        The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
         *        <code>Sidewalk</code>.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder wirelessDeviceType(String wirelessDeviceType);

        /**
         * <p>
         * The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
         * <code>Sidewalk</code>.
         * </p>
         * 
         * @param wirelessDeviceType
         *        The type of wireless device to deregister from AWS IoT Wireless, which can be <code>LoRaWAN</code> or
         *        <code>Sidewalk</code>.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String identifier;

        private String wirelessDeviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterWirelessDeviceRequest model) {
            super(model);
            identifier(model.identifier);
            wirelessDeviceType(model.wirelessDeviceType);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getWirelessDeviceType() {
            return wirelessDeviceType;
        }

        public final void setWirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
        }

        @Override
        public final Builder wirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
            return this;
        }

        @Override
        public final Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType) {
            this.wirelessDeviceType(wirelessDeviceType == null ? null : wirelessDeviceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterWirelessDeviceRequest build() {
            return new DeregisterWirelessDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
