/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPartnerAccountResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetPartnerAccountResponse> {
    private static final SdkField<SidewalkAccountInfoWithFingerprint> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(GetPartnerAccountResponse.getter(GetPartnerAccountResponse::sidewalk)).setter(GetPartnerAccountResponse.setter(Builder::sidewalk)).constructor(SidewalkAccountInfoWithFingerprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<Boolean> ACCOUNT_LINKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccountLinked").getter(GetPartnerAccountResponse.getter(GetPartnerAccountResponse::accountLinked)).setter(GetPartnerAccountResponse.setter(Builder::accountLinked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLinked").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD, ACCOUNT_LINKED_FIELD));
    private final SidewalkAccountInfoWithFingerprint sidewalk;
    private final Boolean accountLinked;

    private GetPartnerAccountResponse(BuilderImpl builder) {
        super(builder);
        this.sidewalk = builder.sidewalk;
        this.accountLinked = builder.accountLinked;
    }

    public final SidewalkAccountInfoWithFingerprint sidewalk() {
        return this.sidewalk;
    }

    public final Boolean accountLinked() {
        return this.accountLinked;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLinked());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartnerAccountResponse)) {
            return false;
        }
        GetPartnerAccountResponse other = (GetPartnerAccountResponse)((Object)obj);
        return Objects.equals(this.sidewalk(), other.sidewalk()) && Objects.equals(this.accountLinked(), other.accountLinked());
    }

    public final String toString() {
        return ToString.builder((String)"GetPartnerAccountResponse").add("Sidewalk", (Object)this.sidewalk()).add("AccountLinked", (Object)this.accountLinked()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "AccountLinked": {
                return Optional.ofNullable(clazz.cast(this.accountLinked()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPartnerAccountResponse, T> g) {
        return obj -> g.apply((GetPartnerAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private SidewalkAccountInfoWithFingerprint sidewalk;
        private Boolean accountLinked;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartnerAccountResponse model) {
            super(model);
            this.sidewalk(model.sidewalk);
            this.accountLinked(model.accountLinked);
        }

        public final SidewalkAccountInfoWithFingerprint.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkAccountInfoWithFingerprint sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final void setSidewalk(SidewalkAccountInfoWithFingerprint.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        public final Boolean getAccountLinked() {
            return this.accountLinked;
        }

        @Override
        public final Builder accountLinked(Boolean accountLinked) {
            this.accountLinked = accountLinked;
            return this;
        }

        public final void setAccountLinked(Boolean accountLinked) {
            this.accountLinked = accountLinked;
        }

        @Override
        public GetPartnerAccountResponse build() {
            return new GetPartnerAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPartnerAccountResponse> {
        public Builder sidewalk(SidewalkAccountInfoWithFingerprint var1);

        default public Builder sidewalk(Consumer<SidewalkAccountInfoWithFingerprint.Builder> sidewalk) {
            return this.sidewalk((SidewalkAccountInfoWithFingerprint)((SidewalkAccountInfoWithFingerprint.Builder)SidewalkAccountInfoWithFingerprint.builder().applyMutation(sidewalk)).build());
        }

        public Builder accountLinked(Boolean var1);
    }
}

