/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSyncJobRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<CreateSyncJobRequest.Builder, CreateSyncJobRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateSyncJobRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSource").getter(getter(CreateSyncJobRequest::syncSource)).setter(setter(Builder::syncSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("syncSource").build()).build();

    private static final SdkField<String> SYNC_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncRole").getter(getter(CreateSyncJobRequest::syncRole)).setter(setter(Builder::syncRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncRole").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSyncJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            SYNC_SOURCE_FIELD, SYNC_ROLE_FIELD, TAGS_FIELD));

    private final String workspaceId;

    private final String syncSource;

    private final String syncRole;

    private final Map<String, String> tags;

    private CreateSyncJobRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.syncSource = builder.syncSource;
        this.syncRole = builder.syncRole;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The workspace ID.
     * </p>
     * 
     * @return The workspace ID.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The sync source.
     * </p>
     * <note>
     * <p>
     * Currently the only supported syncSoource is <code>SITEWISE </code>.
     * </p>
     * </note>
     * 
     * @return The sync source.</p> <note>
     *         <p>
     *         Currently the only supported syncSoource is <code>SITEWISE </code>.
     *         </p>
     */
    public final String syncSource() {
        return syncSource;
    }

    /**
     * <p>
     * The SyncJob IAM role. This IAM role is used by the SyncJob to read from the syncSource, and create, update, or
     * delete the corresponding resources.
     * </p>
     * 
     * @return The SyncJob IAM role. This IAM role is used by the SyncJob to read from the syncSource, and create,
     *         update, or delete the corresponding resources.
     */
    public final String syncRole() {
        return syncRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The SyncJob tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The SyncJob tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(syncRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSyncJobRequest)) {
            return false;
        }
        CreateSyncJobRequest other = (CreateSyncJobRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(syncSource(), other.syncSource())
                && Objects.equals(syncRole(), other.syncRole()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSyncJobRequest").add("WorkspaceId", workspaceId()).add("SyncSource", syncSource())
                .add("SyncRole", syncRole()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "syncSource":
            return Optional.ofNullable(clazz.cast(syncSource()));
        case "syncRole":
            return Optional.ofNullable(clazz.cast(syncRole()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSyncJobRequest, T> g) {
        return obj -> g.apply((CreateSyncJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSyncJobRequest> {
        /**
         * <p>
         * The workspace ID.
         * </p>
         * 
         * @param workspaceId
         *        The workspace ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The sync source.
         * </p>
         * <note>
         * <p>
         * Currently the only supported syncSoource is <code>SITEWISE </code>.
         * </p>
         * </note>
         * 
         * @param syncSource
         *        The sync source.</p> <note>
         *        <p>
         *        Currently the only supported syncSoource is <code>SITEWISE </code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSource(String syncSource);

        /**
         * <p>
         * The SyncJob IAM role. This IAM role is used by the SyncJob to read from the syncSource, and create, update,
         * or delete the corresponding resources.
         * </p>
         * 
         * @param syncRole
         *        The SyncJob IAM role. This IAM role is used by the SyncJob to read from the syncSource, and create,
         *        update, or delete the corresponding resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncRole(String syncRole);

        /**
         * <p>
         * The SyncJob tags.
         * </p>
         * 
         * @param tags
         *        The SyncJob tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String syncSource;

        private String syncRole;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSyncJobRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            syncSource(model.syncSource);
            syncRole(model.syncRole);
            tags(model.tags);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSyncSource() {
            return syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getSyncRole() {
            return syncRole;
        }

        public final void setSyncRole(String syncRole) {
            this.syncRole = syncRole;
        }

        @Override
        public final Builder syncRole(String syncRole) {
            this.syncRole = syncRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSyncJobRequest build() {
            return new CreateSyncJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
