/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ComponentUpdatesMapRequestCopier {
    static Map<String, ComponentUpdateRequest> copy(Map<String, ? extends ComponentUpdateRequest> componentUpdatesMapRequestParam) {
        Map<String, ComponentUpdateRequest> map;
        if (componentUpdatesMapRequestParam == null || componentUpdatesMapRequestParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ComponentUpdateRequest> modifiableMap = new LinkedHashMap<>();
            componentUpdatesMapRequestParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ComponentUpdateRequest> copyFromBuilder(
            Map<String, ? extends ComponentUpdateRequest.Builder> componentUpdatesMapRequestParam) {
        Map<String, ComponentUpdateRequest> map;
        if (componentUpdatesMapRequestParam == null || componentUpdatesMapRequestParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ComponentUpdateRequest> modifiableMap = new LinkedHashMap<>();
            componentUpdatesMapRequestParam.forEach((key, value) -> {
                ComponentUpdateRequest member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ComponentUpdateRequest.Builder> copyToBuilder(
            Map<String, ? extends ComponentUpdateRequest> componentUpdatesMapRequestParam) {
        Map<String, ComponentUpdateRequest.Builder> map;
        if (componentUpdatesMapRequestParam == null || componentUpdatesMapRequestParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ComponentUpdateRequest.Builder> modifiableMap = new LinkedHashMap<>();
            componentUpdatesMapRequestParam.forEach((key, value) -> {
                ComponentUpdateRequest.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
