/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of a job, such as the file format used to save data in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<JobConfiguration.Builder, JobConfiguration> {
    private static final SdkField<FileFormat> FILE_FORMAT_FIELD = SdkField.<FileFormat> builder(MarshallingType.SDK_POJO)
            .memberName("fileFormat").getter(getter(JobConfiguration::fileFormat)).setter(setter(Builder::fileFormat))
            .constructor(FileFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final FileFormat fileFormat;

    private JobConfiguration(BuilderImpl builder) {
        this.fileFormat = builder.fileFormat;
    }

    /**
     * <p>
     * The file format of the data in Amazon S3.
     * </p>
     * 
     * @return The file format of the data in Amazon S3.
     */
    public final FileFormat fileFormat() {
        return fileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobConfiguration)) {
            return false;
        }
        JobConfiguration other = (JobConfiguration) obj;
        return Objects.equals(fileFormat(), other.fileFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobConfiguration").add("FileFormat", fileFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobConfiguration, T> g) {
        return obj -> g.apply((JobConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobConfiguration> {
        /**
         * <p>
         * The file format of the data in Amazon S3.
         * </p>
         * 
         * @param fileFormat
         *        The file format of the data in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * The file format of the data in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileFormat.Builder} avoiding the need to
         * create one manually via {@link FileFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileFormat.Builder#build()} is called immediately and its result
         * is passed to {@link #fileFormat(FileFormat)}.
         * 
         * @param fileFormat
         *        a consumer that will call methods on {@link FileFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileFormat(FileFormat)
         */
        default Builder fileFormat(Consumer<FileFormat.Builder> fileFormat) {
            return fileFormat(FileFormat.builder().applyMutation(fileFormat).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileFormat fileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(JobConfiguration model) {
            fileFormat(model.fileFormat);
        }

        public final FileFormat.Builder getFileFormat() {
            return fileFormat != null ? fileFormat.toBuilder() : null;
        }

        public final void setFileFormat(FileFormat.BuilderImpl fileFormat) {
            this.fileFormat = fileFormat != null ? fileFormat.build() : null;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public JobConfiguration build() {
            return new JobConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
