/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBulkImportJobResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<CreateBulkImportJobResponse.Builder, CreateBulkImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(CreateBulkImportJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateBulkImportJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(CreateBulkImportJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD,
            JOB_STATUS_FIELD));

    private final String jobId;

    private final String jobName;

    private final String jobStatus;

    private CreateBulkImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The unique name that helps identify the job request.
     * </p>
     * 
     * @return The unique name that helps identify the job request.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the bulk import job can be one of following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – The bulk import job has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *         use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *         with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *         issues.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the bulk import job can be one of following values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – The bulk import job has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *         use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *         with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *         issues.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBulkImportJobResponse)) {
            return false;
        }
        CreateBulkImportJobResponse other = (CreateBulkImportJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBulkImportJobResponse").add("JobId", jobId()).add("JobName", jobName())
                .add("JobStatus", jobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBulkImportJobResponse, T> g) {
        return obj -> g.apply((CreateBulkImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateBulkImportJobResponse> {
        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The unique name that helps identify the job request.
         * </p>
         * 
         * @param jobName
         *        The unique name that helps identify the job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The status of the bulk import job can be one of following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – The bulk import job has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use
         * logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
         * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the bulk import job can be one of following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – The bulk import job has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon
         *        S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You
         *        can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon
         *        S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to
         *        troubleshoot issues.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the bulk import job can be one of following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – The bulk import job has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use
         * logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
         * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the bulk import job can be one of following values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – The bulk import job has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon
         *        S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You
         *        can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon
         *        S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to
         *        troubleshoot issues.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBulkImportJobResponse model) {
            super(model);
            jobId(model.jobId);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        @Override
        public CreateBulkImportJobResponse build() {
            return new CreateBulkImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
