/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Attribute;
import software.amazon.awssdk.services.iotsitewise.model.Measurement;
import software.amazon.awssdk.services.iotsitewise.model.Metric;
import software.amazon.awssdk.services.iotsitewise.model.Transform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyType> {
    private static final SdkField<Attribute> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attribute").getter(PropertyType.getter(PropertyType::attribute)).setter(PropertyType.setter(Builder::attribute)).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()}).build();
    private static final SdkField<Measurement> MEASUREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("measurement").getter(PropertyType.getter(PropertyType::measurement)).setter(PropertyType.setter(Builder::measurement)).constructor(Measurement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("measurement").build()}).build();
    private static final SdkField<Transform> TRANSFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transform").getter(PropertyType.getter(PropertyType::transform)).setter(PropertyType.setter(Builder::transform)).constructor(Transform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transform").build()}).build();
    private static final SdkField<Metric> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metric").getter(PropertyType.getter(PropertyType::metric)).setter(PropertyType.setter(Builder::metric)).constructor(Metric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metric").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, MEASUREMENT_FIELD, TRANSFORM_FIELD, METRIC_FIELD));
    private static final long serialVersionUID = 1L;
    private final Attribute attribute;
    private final Measurement measurement;
    private final Transform transform;
    private final Metric metric;

    private PropertyType(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.measurement = builder.measurement;
        this.transform = builder.transform;
        this.metric = builder.metric;
    }

    public final Attribute attribute() {
        return this.attribute;
    }

    public final Measurement measurement() {
        return this.measurement;
    }

    public final Transform transform() {
        return this.transform;
    }

    public final Metric metric() {
        return this.metric;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.measurement());
        hashCode = 31 * hashCode + Objects.hashCode(this.transform());
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyType)) {
            return false;
        }
        PropertyType other = (PropertyType)obj;
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.measurement(), other.measurement()) && Objects.equals(this.transform(), other.transform()) && Objects.equals(this.metric(), other.metric());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyType").add("Attribute", (Object)this.attribute()).add("Measurement", (Object)this.measurement()).add("Transform", (Object)this.transform()).add("Metric", (Object)this.metric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "measurement": {
                return Optional.ofNullable(clazz.cast(this.measurement()));
            }
            case "transform": {
                return Optional.ofNullable(clazz.cast(this.transform()));
            }
            case "metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyType, T> g) {
        return obj -> g.apply((PropertyType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Attribute attribute;
        private Measurement measurement;
        private Transform transform;
        private Metric metric;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyType model) {
            this.attribute(model.attribute);
            this.measurement(model.measurement);
            this.transform(model.transform);
            this.metric(model.metric);
        }

        public final Attribute.Builder getAttribute() {
            return this.attribute != null ? this.attribute.toBuilder() : null;
        }

        public final void setAttribute(Attribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        @Override
        public final Builder attribute(Attribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public final Measurement.Builder getMeasurement() {
            return this.measurement != null ? this.measurement.toBuilder() : null;
        }

        public final void setMeasurement(Measurement.BuilderImpl measurement) {
            this.measurement = measurement != null ? measurement.build() : null;
        }

        @Override
        public final Builder measurement(Measurement measurement) {
            this.measurement = measurement;
            return this;
        }

        public final Transform.Builder getTransform() {
            return this.transform != null ? this.transform.toBuilder() : null;
        }

        public final void setTransform(Transform.BuilderImpl transform) {
            this.transform = transform != null ? transform.build() : null;
        }

        @Override
        public final Builder transform(Transform transform) {
            this.transform = transform;
            return this;
        }

        public final Metric.Builder getMetric() {
            return this.metric != null ? this.metric.toBuilder() : null;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public PropertyType build() {
            return new PropertyType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyType> {
        public Builder attribute(Attribute var1);

        default public Builder attribute(Consumer<Attribute.Builder> attribute) {
            return this.attribute((Attribute)((Attribute.Builder)Attribute.builder().applyMutation(attribute)).build());
        }

        public Builder measurement(Measurement var1);

        default public Builder measurement(Consumer<Measurement.Builder> measurement) {
            return this.measurement((Measurement)((Measurement.Builder)Measurement.builder().applyMutation(measurement)).build());
        }

        public Builder transform(Transform var1);

        default public Builder transform(Consumer<Transform.Builder> transform) {
            return this.transform((Transform)((Transform.Builder)Transform.builder().applyMutation(transform)).build());
        }

        public Builder metric(Metric var1);

        default public Builder metric(Consumer<Metric.Builder> metric) {
            return this.metric((Metric)((Metric.Builder)Metric.builder().applyMutation(metric)).build());
        }
    }
}

